/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.rbac.v1alpha1.Target;
import me.snowdrop.istio.api.rbac.v1alpha1.TargetFluent;
import me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelector;
import me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorBuilder;
import me.snowdrop.istio.api.rbac.v1alpha1.WorkloadSelectorFluentImpl;

public class TargetFluentImpl<A extends TargetFluent<A>>
extends BaseFluent<A>
implements TargetFluent<A> {
    private List<String> namespaces;
    private List<String> services;
    private List<WorkloadSelectorBuilder> workloadSelectors;

    public TargetFluentImpl() {
    }

    public TargetFluentImpl(Target instance) {
        this.withNamespaces(instance.getNamespaces());
        this.withServices(instance.getServices());
        this.withWorkloadSelectors(instance.getWorkloadSelectors());
    }

    @Override
    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) {
            this._visitables.get((Object)"namespaces").removeAll(this.namespaces);
        }
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addNewNamespace(String arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuilder arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuffer arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServices(String ... items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServices(Collection<String> items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServices(String ... items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServices(Collection<String> items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServices() {
        return this.services;
    }

    @Override
    public String getService(int index) {
        return this.services.get(index);
    }

    @Override
    public String getFirstService() {
        return this.services.get(0);
    }

    @Override
    public String getLastService() {
        return this.services.get(this.services.size() - 1);
    }

    @Override
    public String getMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServices(List<String> services) {
        if (this.services != null) {
            this._visitables.get((Object)"services").removeAll(this.services);
        }
        if (services != null) {
            this.services = new ArrayList<String>();
            for (String item : services) {
                this.addToServices(item);
            }
        } else {
            this.services = null;
        }
        return (A)this;
    }

    @Override
    public A withServices(String ... services) {
        if (this.services != null) {
            this.services.clear();
        }
        if (services != null) {
            for (String item : services) {
                this.addToServices(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    @Override
    public A addNewService(String arg1) {
        return this.addToServices(new String(arg1));
    }

    @Override
    public A addNewService(StringBuilder arg1) {
        return this.addToServices(new String(arg1));
    }

    @Override
    public A addNewService(StringBuffer arg1) {
        return this.addToServices(new String(arg1));
    }

    @Override
    public A addToWorkloadSelectors(int index, WorkloadSelector item) {
        if (this.workloadSelectors == null) {
            this.workloadSelectors = new ArrayList<WorkloadSelectorBuilder>();
        }
        WorkloadSelectorBuilder builder = new WorkloadSelectorBuilder(item);
        this._visitables.get((Object)"workloadSelectors").add(index >= 0 ? index : this._visitables.get((Object)"workloadSelectors").size(), builder);
        this.workloadSelectors.add(index >= 0 ? index : this.workloadSelectors.size(), builder);
        return (A)this;
    }

    @Override
    public A setToWorkloadSelectors(int index, WorkloadSelector item) {
        if (this.workloadSelectors == null) {
            this.workloadSelectors = new ArrayList<WorkloadSelectorBuilder>();
        }
        WorkloadSelectorBuilder builder = new WorkloadSelectorBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"workloadSelectors").size()) {
            this._visitables.get((Object)"workloadSelectors").add(builder);
        } else {
            this._visitables.get((Object)"workloadSelectors").set(index, builder);
        }
        if (index < 0 || index >= this.workloadSelectors.size()) {
            this.workloadSelectors.add(builder);
        } else {
            this.workloadSelectors.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToWorkloadSelectors(WorkloadSelector ... items) {
        if (this.workloadSelectors == null) {
            this.workloadSelectors = new ArrayList<WorkloadSelectorBuilder>();
        }
        for (WorkloadSelector item : items) {
            WorkloadSelectorBuilder builder = new WorkloadSelectorBuilder(item);
            this._visitables.get((Object)"workloadSelectors").add(builder);
            this.workloadSelectors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToWorkloadSelectors(Collection<WorkloadSelector> items) {
        if (this.workloadSelectors == null) {
            this.workloadSelectors = new ArrayList<WorkloadSelectorBuilder>();
        }
        for (WorkloadSelector item : items) {
            WorkloadSelectorBuilder builder = new WorkloadSelectorBuilder(item);
            this._visitables.get((Object)"workloadSelectors").add(builder);
            this.workloadSelectors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromWorkloadSelectors(WorkloadSelector ... items) {
        for (WorkloadSelector item : items) {
            WorkloadSelectorBuilder builder = new WorkloadSelectorBuilder(item);
            this._visitables.get((Object)"workloadSelectors").remove(builder);
            if (this.workloadSelectors == null) continue;
            this.workloadSelectors.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWorkloadSelectors(Collection<WorkloadSelector> items) {
        for (WorkloadSelector item : items) {
            WorkloadSelectorBuilder builder = new WorkloadSelectorBuilder(item);
            this._visitables.get((Object)"workloadSelectors").remove(builder);
            if (this.workloadSelectors == null) continue;
            this.workloadSelectors.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<WorkloadSelector> getWorkloadSelectors() {
        return TargetFluentImpl.build(this.workloadSelectors);
    }

    @Override
    public List<WorkloadSelector> buildWorkloadSelectors() {
        return TargetFluentImpl.build(this.workloadSelectors);
    }

    @Override
    public WorkloadSelector buildWorkloadSelector(int index) {
        return this.workloadSelectors.get(index).build();
    }

    @Override
    public WorkloadSelector buildFirstWorkloadSelector() {
        return this.workloadSelectors.get(0).build();
    }

    @Override
    public WorkloadSelector buildLastWorkloadSelector() {
        return this.workloadSelectors.get(this.workloadSelectors.size() - 1).build();
    }

    @Override
    public WorkloadSelector buildMatchingWorkloadSelector(Predicate<WorkloadSelectorBuilder> predicate) {
        for (WorkloadSelectorBuilder item : this.workloadSelectors) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWorkloadSelector(Predicate<WorkloadSelectorBuilder> predicate) {
        for (WorkloadSelectorBuilder item : this.workloadSelectors) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWorkloadSelectors(List<WorkloadSelector> workloadSelectors) {
        if (this.workloadSelectors != null) {
            this._visitables.get((Object)"workloadSelectors").removeAll(this.workloadSelectors);
        }
        if (workloadSelectors != null) {
            this.workloadSelectors = new ArrayList<WorkloadSelectorBuilder>();
            for (WorkloadSelector item : workloadSelectors) {
                this.addToWorkloadSelectors(item);
            }
        } else {
            this.workloadSelectors = null;
        }
        return (A)this;
    }

    @Override
    public A withWorkloadSelectors(WorkloadSelector ... workloadSelectors) {
        if (this.workloadSelectors != null) {
            this.workloadSelectors.clear();
        }
        if (workloadSelectors != null) {
            for (WorkloadSelector item : workloadSelectors) {
                this.addToWorkloadSelectors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWorkloadSelectors() {
        return this.workloadSelectors != null && !this.workloadSelectors.isEmpty();
    }

    @Override
    public TargetFluent.WorkloadSelectorsNested<A> addNewWorkloadSelector() {
        return new WorkloadSelectorsNestedImpl();
    }

    @Override
    public TargetFluent.WorkloadSelectorsNested<A> addNewWorkloadSelectorLike(WorkloadSelector item) {
        return new WorkloadSelectorsNestedImpl(-1, item);
    }

    @Override
    public TargetFluent.WorkloadSelectorsNested<A> setNewWorkloadSelectorLike(int index, WorkloadSelector item) {
        return new WorkloadSelectorsNestedImpl(index, item);
    }

    @Override
    public TargetFluent.WorkloadSelectorsNested<A> editWorkloadSelector(int index) {
        if (this.workloadSelectors.size() <= index) {
            throw new RuntimeException("Can't edit workloadSelectors. Index exceeds size.");
        }
        return this.setNewWorkloadSelectorLike(index, this.buildWorkloadSelector(index));
    }

    @Override
    public TargetFluent.WorkloadSelectorsNested<A> editFirstWorkloadSelector() {
        if (this.workloadSelectors.size() == 0) {
            throw new RuntimeException("Can't edit first workloadSelectors. The list is empty.");
        }
        return this.setNewWorkloadSelectorLike(0, this.buildWorkloadSelector(0));
    }

    @Override
    public TargetFluent.WorkloadSelectorsNested<A> editLastWorkloadSelector() {
        int index = this.workloadSelectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last workloadSelectors. The list is empty.");
        }
        return this.setNewWorkloadSelectorLike(index, this.buildWorkloadSelector(index));
    }

    @Override
    public TargetFluent.WorkloadSelectorsNested<A> editMatchingWorkloadSelector(Predicate<WorkloadSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.workloadSelectors.size(); ++i) {
            if (!predicate.apply((Object)this.workloadSelectors.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching workloadSelectors. No match found.");
        }
        return this.setNewWorkloadSelectorLike(index, this.buildWorkloadSelector(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TargetFluentImpl that = (TargetFluentImpl)o;
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        if (this.services != null ? !this.services.equals(that.services) : that.services != null) {
            return false;
        }
        return !(this.workloadSelectors != null ? !this.workloadSelectors.equals(that.workloadSelectors) : that.workloadSelectors != null);
    }

    public class WorkloadSelectorsNestedImpl<N>
    extends WorkloadSelectorFluentImpl<TargetFluent.WorkloadSelectorsNested<N>>
    implements TargetFluent.WorkloadSelectorsNested<N>,
    Nested<N> {
        private final WorkloadSelectorBuilder builder;
        private final int index;

        WorkloadSelectorsNestedImpl(int index, WorkloadSelector item) {
            this.index = index;
            this.builder = new WorkloadSelectorBuilder(this, item);
        }

        WorkloadSelectorsNestedImpl() {
            this.index = -1;
            this.builder = new WorkloadSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)TargetFluentImpl.this.setToWorkloadSelectors(this.index, this.builder.build());
        }

        @Override
        public N endWorkloadSelector() {
            return this.and();
        }
    }
}

