/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPCookie;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPCookieFluent;
import me.snowdrop.istio.api.networking.v1alpha3.HTTPCookieFluentImpl;

public class HTTPCookieBuilder
extends HTTPCookieFluentImpl<HTTPCookieBuilder>
implements VisitableBuilder<HTTPCookie, HTTPCookieBuilder> {
    HTTPCookieFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPCookieBuilder() {
        this(true);
    }

    public HTTPCookieBuilder(Boolean validationEnabled) {
        this(new HTTPCookie(), validationEnabled);
    }

    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPCookie(), validationEnabled);
    }

    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent, HTTPCookie instance) {
        this(fluent, instance, true);
    }

    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent, HTTPCookie instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withPath(instance.getPath());
        fluent.withTtl(instance.getTtl());
        this.validationEnabled = validationEnabled;
    }

    public HTTPCookieBuilder(HTTPCookie instance) {
        this(instance, (Boolean)true);
    }

    public HTTPCookieBuilder(HTTPCookie instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withPath(instance.getPath());
        this.withTtl(instance.getTtl());
        this.validationEnabled = validationEnabled;
    }

    public HTTPCookieBuilder(Validator validator) {
        this(new HTTPCookie(), (Boolean)true);
    }

    public HTTPCookieBuilder(HTTPCookieFluent<?> fluent, HTTPCookie instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withPath(instance.getPath());
        fluent.withTtl(instance.getTtl());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public HTTPCookieBuilder(HTTPCookie instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withPath(instance.getPath());
        this.withTtl(instance.getTtl());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public HTTPCookie build() {
        HTTPCookie buildable = new HTTPCookie(this.fluent.getName(), this.fluent.getPath(), this.fluent.getTtl());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPCookieBuilder that = (HTTPCookieBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

