/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.snowdrop.istio.api.networking.v1alpha3.EnvoyFilterSpec;
import me.snowdrop.istio.api.networking.v1alpha3.EnvoyFilterSpecFluent;
import me.snowdrop.istio.api.networking.v1alpha3.Filter;
import me.snowdrop.istio.api.networking.v1alpha3.FilterBuilder;
import me.snowdrop.istio.api.networking.v1alpha3.FilterFluentImpl;

public class EnvoyFilterSpecFluentImpl<A extends EnvoyFilterSpecFluent<A>>
extends BaseFluent<A>
implements EnvoyFilterSpecFluent<A> {
    private List<FilterBuilder> filters;
    private Map<String, String> workloadLabels;

    public EnvoyFilterSpecFluentImpl() {
    }

    public EnvoyFilterSpecFluentImpl(EnvoyFilterSpec instance) {
        this.withFilters(instance.getFilters());
        this.withWorkloadLabels(instance.getWorkloadLabels());
    }

    @Override
    public A addToFilters(int index, Filter item) {
        if (this.filters == null) {
            this.filters = new ArrayList<FilterBuilder>();
        }
        FilterBuilder builder = new FilterBuilder(item);
        this._visitables.get((Object)"filters").add(index >= 0 ? index : this._visitables.get((Object)"filters").size(), builder);
        this.filters.add(index >= 0 ? index : this.filters.size(), builder);
        return (A)this;
    }

    @Override
    public A setToFilters(int index, Filter item) {
        if (this.filters == null) {
            this.filters = new ArrayList<FilterBuilder>();
        }
        FilterBuilder builder = new FilterBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"filters").size()) {
            this._visitables.get((Object)"filters").add(builder);
        } else {
            this._visitables.get((Object)"filters").set(index, builder);
        }
        if (index < 0 || index >= this.filters.size()) {
            this.filters.add(builder);
        } else {
            this.filters.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToFilters(Filter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList<FilterBuilder>();
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToFilters(Collection<Filter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList<FilterBuilder>();
        }
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromFilters(Filter ... items) {
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").remove(builder);
            if (this.filters == null) continue;
            this.filters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFilters(Collection<Filter> items) {
        for (Filter item : items) {
            FilterBuilder builder = new FilterBuilder(item);
            this._visitables.get((Object)"filters").remove(builder);
            if (this.filters == null) continue;
            this.filters.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Filter> getFilters() {
        return EnvoyFilterSpecFluentImpl.build(this.filters);
    }

    @Override
    public List<Filter> buildFilters() {
        return EnvoyFilterSpecFluentImpl.build(this.filters);
    }

    @Override
    public Filter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    @Override
    public Filter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    @Override
    public Filter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    @Override
    public Filter buildMatchingFilter(Predicate<FilterBuilder> predicate) {
        for (FilterBuilder item : this.filters) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFilter(Predicate<FilterBuilder> predicate) {
        for (FilterBuilder item : this.filters) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFilters(List<Filter> filters) {
        if (this.filters != null) {
            this._visitables.get((Object)"filters").removeAll(this.filters);
        }
        if (filters != null) {
            this.filters = new ArrayList<FilterBuilder>();
            for (Filter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)this;
    }

    @Override
    public A withFilters(Filter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
        }
        if (filters != null) {
            for (Filter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    @Override
    public EnvoyFilterSpecFluent.FiltersNested<A> addNewFilter() {
        return new FiltersNestedImpl();
    }

    @Override
    public EnvoyFilterSpecFluent.FiltersNested<A> addNewFilterLike(Filter item) {
        return new FiltersNestedImpl(-1, item);
    }

    @Override
    public EnvoyFilterSpecFluent.FiltersNested<A> setNewFilterLike(int index, Filter item) {
        return new FiltersNestedImpl(index, item);
    }

    @Override
    public EnvoyFilterSpecFluent.FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public EnvoyFilterSpecFluent.FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    @Override
    public EnvoyFilterSpecFluent.FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public EnvoyFilterSpecFluent.FiltersNested<A> editMatchingFilter(Predicate<FilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.apply((Object)this.filters.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public A addToWorkloadLabels(String key, String value) {
        if (this.workloadLabels == null && key != null && value != null) {
            this.workloadLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.workloadLabels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToWorkloadLabels(Map<String, String> map) {
        if (this.workloadLabels == null && map != null) {
            this.workloadLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.workloadLabels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromWorkloadLabels(String key) {
        if (this.workloadLabels == null) {
            return (A)this;
        }
        if (key != null && this.workloadLabels != null) {
            this.workloadLabels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromWorkloadLabels(Map<String, String> map) {
        if (this.workloadLabels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.workloadLabels == null) continue;
                this.workloadLabels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getWorkloadLabels() {
        return this.workloadLabels;
    }

    @Override
    public A withWorkloadLabels(Map<String, String> workloadLabels) {
        this.workloadLabels = workloadLabels == null ? null : new LinkedHashMap<String, String>(workloadLabels);
        return (A)this;
    }

    @Override
    public Boolean hasWorkloadLabels() {
        return this.workloadLabels != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvoyFilterSpecFluentImpl that = (EnvoyFilterSpecFluentImpl)o;
        if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) {
            return false;
        }
        return !(this.workloadLabels != null ? !this.workloadLabels.equals(that.workloadLabels) : that.workloadLabels != null);
    }

    public class FiltersNestedImpl<N>
    extends FilterFluentImpl<EnvoyFilterSpecFluent.FiltersNested<N>>
    implements EnvoyFilterSpecFluent.FiltersNested<N>,
    Nested<N> {
        private final FilterBuilder builder;
        private final int index;

        FiltersNestedImpl(int index, Filter item) {
            this.index = index;
            this.builder = new FilterBuilder(this, item);
        }

        FiltersNestedImpl() {
            this.index = -1;
            this.builder = new FilterBuilder(this);
        }

        @Override
        public N and() {
            return (N)EnvoyFilterSpecFluentImpl.this.setToFilters(this.index, this.builder.build());
        }

        @Override
        public N endFilter() {
            return this.and();
        }
    }
}

