/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.networking.v1alpha3.Destination;
import me.snowdrop.istio.api.networking.v1alpha3.DestinationFluent;
import me.snowdrop.istio.api.networking.v1alpha3.DestinationFluentImpl;

public class DestinationBuilder
extends DestinationFluentImpl<DestinationBuilder>
implements VisitableBuilder<Destination, DestinationBuilder> {
    DestinationFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DestinationBuilder() {
        this(true);
    }

    public DestinationBuilder(Boolean validationEnabled) {
        this(new Destination(), validationEnabled);
    }

    public DestinationBuilder(DestinationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DestinationBuilder(DestinationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Destination(), validationEnabled);
    }

    public DestinationBuilder(DestinationFluent<?> fluent, Destination instance) {
        this(fluent, instance, true);
    }

    public DestinationBuilder(DestinationFluent<?> fluent, Destination instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withPort(instance.getPort());
        fluent.withSubset(instance.getSubset());
        this.validationEnabled = validationEnabled;
    }

    public DestinationBuilder(Destination instance) {
        this(instance, (Boolean)true);
    }

    public DestinationBuilder(Destination instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withPort(instance.getPort());
        this.withSubset(instance.getSubset());
        this.validationEnabled = validationEnabled;
    }

    public DestinationBuilder(Validator validator) {
        this(new Destination(), (Boolean)true);
    }

    public DestinationBuilder(DestinationFluent<?> fluent, Destination instance, Validator validator) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withPort(instance.getPort());
        fluent.withSubset(instance.getSubset());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public DestinationBuilder(Destination instance, Validator validator) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withPort(instance.getPort());
        this.withSubset(instance.getSubset());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Destination build() {
        Destination buildable = new Destination(this.fluent.getHost(), this.fluent.getPort(), this.fluent.getSubset());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DestinationBuilder that = (DestinationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

