/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.cexl.parser;

import me.snowdrop.istio.api.cexl.AttributeVocabulary;
import me.snowdrop.istio.api.cexl.parser.CEXLBaseListener;
import me.snowdrop.istio.api.cexl.parser.CEXLParser;
import me.snowdrop.istio.api.mixer.config.descriptor.ValueType;
import org.antlr.v4.runtime.tree.TerminalNode;

public class CEXLTypeResolver
extends CEXLBaseListener {
    private static final String DEFAULT_OPERATOR = "|";
    private ValueType expressionType;

    public ValueType getExpressionType() {
        return this.expressionType;
    }

    @Override
    public void exitExpression(CEXLParser.ExpressionContext ctx) {
        this.expressionType = this.evaluate(ctx);
    }

    private ValueType evaluate(CEXLParser.ExpressionContext ctx) {
        ValueType rightEvaluation;
        CEXLParser.ParenExprContext parenExprContext = ctx.parenExpr();
        if (parenExprContext != null) {
            return this.evaluate(parenExprContext.expression());
        }
        CEXLParser.FirstNonEmptyExprContext firstNonEmptyExprContext = ctx.firstNonEmptyExpr();
        if (firstNonEmptyExprContext != null) {
            return this.evaluate(firstNonEmptyExprContext);
        }
        CEXLParser.PrimaryExprContext primaryExprContext = ctx.primaryExpr();
        if (primaryExprContext != null) {
            return this.evaluate(primaryExprContext);
        }
        CEXLParser.ExpressionContext left = ctx.expression(0);
        CEXLParser.ExpressionContext right = ctx.expression(1);
        ValueType leftEvaluation = this.evaluate(left);
        if (leftEvaluation != (rightEvaluation = this.evaluate(right))) {
            throw new IllegalArgumentException(String.format("Both sides of expression don't evaluate to same type. Left side '%s' evaluates to '%s', while right side '%s' evaluates to '%s'", left.getText(), leftEvaluation.name(), right.getText(), rightEvaluation.name()));
        }
        return ValueType.BOOL;
    }

    private ValueType evaluate(CEXLParser.FirstNonEmptyExprContext ctx) {
        return ctx.primaryExpr().stream().filter(child -> !child.getText().equals(DEFAULT_OPERATOR)).map(primaryExprContext -> this.evaluate((CEXLParser.PrimaryExprContext)((Object)primaryExprContext))).reduce(ValueType.VALUE_TYPE_UNSPECIFIED, (valueType, valueType2) -> {
            if (valueType == ValueType.VALUE_TYPE_UNSPECIFIED || valueType == valueType2) {
                return valueType2;
            }
            throw new IllegalArgumentException(String.format("Expression '%s' doesn't evaluate to a consistent type", ctx.getText()));
        });
    }

    private ValueType evaluate(CEXLParser.PrimaryExprContext ctx) {
        TerminalNode identifier;
        CEXLParser.OperandContext operandExp = ctx.operand();
        if (operandExp != null) {
            return this.evaluate(operandExp);
        }
        CEXLParser.IndexExprContext indexExpr = ctx.indexExpr();
        if (indexExpr != null && (identifier = indexExpr.ATTRIBUTE_NAME()) != null) {
            AttributeVocabulary.getInfoFor(identifier.getText()).filter(it -> it.type == ValueType.STRING_MAP).orElseThrow(() -> new IllegalArgumentException(String.format("Indexed expression '%s' doesn't start with a valid identifier or is not of type '%s'", new Object[]{indexExpr.getText(), ValueType.STRING_MAP})));
            return ValueType.STRING;
        }
        return ValueType.VALUE_TYPE_UNSPECIFIED;
    }

    private ValueType evaluate(CEXLParser.OperandContext operandExp) {
        TerminalNode identifier = operandExp.ATTRIBUTE_NAME();
        if (identifier != null) {
            String attribute = identifier.getText();
            return AttributeVocabulary.getInfoFor(attribute).map(info -> info.type).orElseThrow(() -> new IllegalArgumentException("Unknown attribute " + attribute));
        }
        CEXLParser.LiteralContext literal = operandExp.literal();
        TerminalNode intLit = literal.INT_LIT();
        if (intLit != null) {
            return ValueType.INT64;
        }
        TerminalNode ipLit = literal.IP_LIT();
        if (ipLit != null) {
            return ValueType.IP_ADDRESS;
        }
        TerminalNode stringLit = literal.STRING_LIT();
        if (stringLit != null) {
            return ValueType.STRING;
        }
        return ValueType.VALUE_TYPE_UNSPECIFIED;
    }
}

