/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.cexl;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.snowdrop.istio.api.mixer.config.descriptor.ValueType;

public class AttributeVocabulary {
    private static final Map<String, AttributeInfo> ATTRIBUTE_INFO_MAP = new ConcurrentHashMap<String, AttributeInfo>();
    public static final String source_ip = "source.ip";
    public static final String source_service = "source.service";
    public static final String source_name = "source.name";
    public static final String source_namespace = "source.namespace";
    public static final String source_domain = "source.domain";
    public static final String source_uid = "source.uid";
    public static final String source_labels = "source.labels";
    public static final String source_user = "source.user";
    public static final String destination_ip = "destination.ip";
    public static final String destination_port = "destination.port";
    public static final String destination_service = "destination.service";
    public static final String destination_name = "destination.name";
    public static final String destination_namespace = "destination.namespace";
    public static final String destination_domain = "destination.domain";
    public static final String destination_uid = "destination.uid";
    public static final String destination_labels = "destination.labels";
    public static final String destination_user = "destination.user";
    public static final String request_headers = "request.headers";
    public static final String request_id = "request.id";
    public static final String request_path = "request.path";
    public static final String request_host = "request.host";
    public static final String request_method = "request.method";
    public static final String request_reason = "request.reason";
    public static final String request_referer = "request.referer";
    public static final String request_scheme = "request.scheme";
    public static final String request_size = "request.size";
    public static final String request_time = "request.time";
    public static final String request_useragent = "request.useragent";
    public static final String response_headers = "response.headers";
    public static final String response_size = "response.size";
    public static final String response_time = "response.time";
    public static final String response_duration = "response.duration";
    public static final String response_code = "response.code";
    public static final String connection_id = "connection.id";
    public static final String connection_received_bytes = "connection.received.bytes";
    public static final String connection_received_bytes_total = "connection.received.bytes_total";
    public static final String connection_sent_bytes = "connection.sent.bytes";
    public static final String connection_sent_bytes_total = "connection.sent.bytes_total";
    public static final String connection_duration = "connection.duration";
    public static final String context_protocol = "context.protocol";
    public static final String context_time = "context.time";
    public static final String api_service = "api.service";
    public static final String api_version = "api.version";
    public static final String api_operation = "api.operation";
    public static final String api_protocol = "api.protocol";
    public static final String request_auth_principal = "request.auth.principal";
    public static final String request_auth_audiences = "request.auth.audiences";
    public static final String request_auth_presenter = "request.auth.presenter";
    public static final String request_api_key = "request.api_key";
    public static final String check_error_code = "check.error_code";
    public static final String check_error_message = "check.error_message";

    public static Optional<AttributeInfo> getInfoFor(String attributeName) {
        return Optional.ofNullable(ATTRIBUTE_INFO_MAP.get(attributeName));
    }

    public static Set<String> getKnownAttributes() {
        return Collections.unmodifiableSet(ATTRIBUTE_INFO_MAP.keySet());
    }

    private AttributeVocabulary() {
    }

    static {
        ATTRIBUTE_INFO_MAP.put(source_ip, new AttributeInfo(source_ip, "ip_address", "Client IP address.", "10.0.0.117"));
        ATTRIBUTE_INFO_MAP.put(source_service, new AttributeInfo(source_service, "string", "The fully qualified name of the service that the client belongs to.", "redis-master.my-namespace.svc.cluster.local"));
        ATTRIBUTE_INFO_MAP.put(source_name, new AttributeInfo(source_name, "string", "The short name part of the source service.", "redis-master"));
        ATTRIBUTE_INFO_MAP.put(source_namespace, new AttributeInfo(source_namespace, "string", "The namespace part of the source service.", "my-namespace"));
        ATTRIBUTE_INFO_MAP.put(source_domain, new AttributeInfo(source_domain, "string", "The domain suffix part of the source service, excluding the name and the namespace.", "svc.cluster.local"));
        ATTRIBUTE_INFO_MAP.put(source_uid, new AttributeInfo(source_uid, "string", "Platform-specific unique identifier for the client instance of the source service.", "kubernetes://redis-master-2353460263-1ecey.my-namespace"));
        ATTRIBUTE_INFO_MAP.put(source_labels, new AttributeInfo(source_labels, ValueType.STRING_MAP.name(), "A map of key-value pairs attached to the client instance.", "version => v1"));
        ATTRIBUTE_INFO_MAP.put(source_user, new AttributeInfo(source_user, "string", "The identity of the immediate sender of the request, authenticated by mTLS.", "service-account-foo"));
        ATTRIBUTE_INFO_MAP.put(destination_ip, new AttributeInfo(destination_ip, "ip_address", "Server IP address.", "10.0.0.104"));
        ATTRIBUTE_INFO_MAP.put(destination_port, new AttributeInfo(destination_port, "int64", "The recipient port on the server IP address.", "8080"));
        ATTRIBUTE_INFO_MAP.put(destination_service, new AttributeInfo(destination_service, "string", "The fully qualified name of the service that the server belongs to.", "my-svc.my-namespace.svc.cluster.local"));
        ATTRIBUTE_INFO_MAP.put(destination_name, new AttributeInfo(destination_name, "string", "The short name part of the destination service.", "my-svc"));
        ATTRIBUTE_INFO_MAP.put(destination_namespace, new AttributeInfo(destination_namespace, "string", "The namespace part of the destination service.", "my-namespace"));
        ATTRIBUTE_INFO_MAP.put(destination_domain, new AttributeInfo(destination_domain, "string", "The domain suffix part of the destination service, excluding the name and the namespace.", "svc.cluster.local"));
        ATTRIBUTE_INFO_MAP.put(destination_uid, new AttributeInfo(destination_uid, "string", "Platform-specific unique identifier for the server instance of the destination service.", "kubernetes://my-svc-234443-5sffe.my-namespace"));
        ATTRIBUTE_INFO_MAP.put(destination_labels, new AttributeInfo(destination_labels, ValueType.STRING_MAP.name(), "A map of key-value pairs attached to the server instance.", "version => v2"));
        ATTRIBUTE_INFO_MAP.put(destination_user, new AttributeInfo(destination_user, "string", "The user running the destination application.", "service-account"));
        ATTRIBUTE_INFO_MAP.put(request_headers, new AttributeInfo(request_headers, ValueType.STRING_MAP.name(), "HTTP request headers. For gRPC, its metadata will be here.", ""));
        ATTRIBUTE_INFO_MAP.put(request_id, new AttributeInfo(request_id, "string", "An ID for the request with statistically low probability of collision.", ""));
        ATTRIBUTE_INFO_MAP.put(request_path, new AttributeInfo(request_path, "string", "The HTTP URL path including query string", ""));
        ATTRIBUTE_INFO_MAP.put(request_host, new AttributeInfo(request_host, "string", "HTTP/1.x host header or HTTP/2 authority header.", "redis-master:3337"));
        ATTRIBUTE_INFO_MAP.put(request_method, new AttributeInfo(request_method, "string", "The HTTP method.", ""));
        ATTRIBUTE_INFO_MAP.put(request_reason, new AttributeInfo(request_reason, "string", "The request reason used by auditing systems.", ""));
        ATTRIBUTE_INFO_MAP.put(request_referer, new AttributeInfo(request_referer, "string", "The HTTP referer header.", ""));
        ATTRIBUTE_INFO_MAP.put(request_scheme, new AttributeInfo(request_scheme, "string", "URI Scheme of the request", ""));
        ATTRIBUTE_INFO_MAP.put(request_size, new AttributeInfo(request_size, "int64", "Size of the request in bytes. For HTTP requests this is equivalent to the Content-Length header.", ""));
        ATTRIBUTE_INFO_MAP.put(request_time, new AttributeInfo(request_time, "timestamp", "The timestamp when the destination receives the request. This should be equivalent to Firebase \"now\".", ""));
        ATTRIBUTE_INFO_MAP.put(request_useragent, new AttributeInfo(request_useragent, "string", "The HTTP User-Agent header.", ""));
        ATTRIBUTE_INFO_MAP.put(response_headers, new AttributeInfo(response_headers, ValueType.STRING_MAP.name(), "HTTP response headers.", ""));
        ATTRIBUTE_INFO_MAP.put(response_size, new AttributeInfo(response_size, "int64", "Size of the response body in bytes", ""));
        ATTRIBUTE_INFO_MAP.put(response_time, new AttributeInfo(response_time, "timestamp", "The timestamp when the destination produced the response.", ""));
        ATTRIBUTE_INFO_MAP.put(response_duration, new AttributeInfo(response_duration, "duration", "The amount of time the response took to generate.", ""));
        ATTRIBUTE_INFO_MAP.put(response_code, new AttributeInfo(response_code, "int64", "The response's HTTP status code.", ""));
        ATTRIBUTE_INFO_MAP.put(connection_id, new AttributeInfo(connection_id, "string", "An ID for a TCP connection with statistically low probability of collision.", ""));
        ATTRIBUTE_INFO_MAP.put(connection_received_bytes, new AttributeInfo(connection_received_bytes, "int64", "Number of bytes received by a destination service on a connection since the last Report() for a connection.", ""));
        ATTRIBUTE_INFO_MAP.put(connection_received_bytes_total, new AttributeInfo(connection_received_bytes_total, "int64", "Total number of bytes received by a destination service during the lifetime of a connection.", ""));
        ATTRIBUTE_INFO_MAP.put(connection_sent_bytes, new AttributeInfo(connection_sent_bytes, "int64", "Number of bytes sent by a destination service on a connection since the last Report() for a connection.", ""));
        ATTRIBUTE_INFO_MAP.put(connection_sent_bytes_total, new AttributeInfo(connection_sent_bytes_total, "int64", "Total number of bytes sent by a destination service during the lifetime of a connection.", ""));
        ATTRIBUTE_INFO_MAP.put(connection_duration, new AttributeInfo(connection_duration, "duration", "The total amount of time a connection has been open.", ""));
        ATTRIBUTE_INFO_MAP.put(context_protocol, new AttributeInfo(context_protocol, "string", "Protocol of the request or connection being proxied.", "tcp"));
        ATTRIBUTE_INFO_MAP.put(context_time, new AttributeInfo(context_time, "timestamp", "The timestamp of Mixer operation.", ""));
        ATTRIBUTE_INFO_MAP.put(api_service, new AttributeInfo(api_service, "string", "The public service name. This is different than the in-mesh service identity and reflects the name of the service exposed to the client.", "my-svc.com"));
        ATTRIBUTE_INFO_MAP.put(api_version, new AttributeInfo(api_version, "string", "The API version.", "v1alpha1"));
        ATTRIBUTE_INFO_MAP.put(api_operation, new AttributeInfo(api_operation, "string", "Unique string used to identify the operation. The id is unique among all operations described in a specific <service, version>.", "getPetsById"));
        ATTRIBUTE_INFO_MAP.put(api_protocol, new AttributeInfo(api_protocol, "string", "The protocol type of the API call. Mainly for monitoring/analytics. Note that this is the frontend protocol exposed to the client, not the protocol implemented by the backend service.", "\"http\", \"https\", or \"grpc\""));
        ATTRIBUTE_INFO_MAP.put(request_auth_principal, new AttributeInfo(request_auth_principal, "string", "The authenticated principal of the request. This is a string of the issuer (`iss`) and subject (`sub`) claims within a JWT concatenated with \"/\" with a percent-encoded subject value.", "accounts.my-svc.com/104958560606"));
        ATTRIBUTE_INFO_MAP.put(request_auth_audiences, new AttributeInfo(request_auth_audiences, "string", "The intended audience(s) for this authentication information. This should reflect the audience (`aud`) claim within a JWT.", "['my-svc.com', 'scopes/read']"));
        ATTRIBUTE_INFO_MAP.put(request_auth_presenter, new AttributeInfo(request_auth_presenter, "string", "The authorized presenter of the credential. This value should reflect the optional Authorized Presenter (`azp`) claim within a JWT or the OAuth2 client id.", "123456789012.my-svc.com"));
        ATTRIBUTE_INFO_MAP.put(request_api_key, new AttributeInfo(request_api_key, "string", "The API key used for the request.", "abcde12345"));
        ATTRIBUTE_INFO_MAP.put(check_error_code, new AttributeInfo(check_error_code, "int64", "The error [code](https://github.com/google/protobuf/blob/master/src/google/protobuf/stubs/status.h#L44) for Mixer Check call.", "5"));
        ATTRIBUTE_INFO_MAP.put(check_error_message, new AttributeInfo(check_error_message, "string", "The error message for Mixer Check call.", "Could not find the resource"));
    }

    public static class AttributeInfo {
        public final String name;
        public final ValueType type;
        public final String description;
        public final String example;

        private AttributeInfo(String name, String istioType, String description, String example) {
            this.name = name;
            this.type = ValueType.valueOf(istioType.toUpperCase());
            this.description = description;
            this.example = example;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeInfo info = (AttributeInfo)o;
            if (!this.name.equals(info.name)) {
                return false;
            }
            return this.type == info.type;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

