package me.snowdrop.istio.mixer.template.logentry;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class LogEntryBuilder extends LogEntryFluentImpl<LogEntryBuilder> implements VisitableBuilder<LogEntry,LogEntryBuilder>{

    LogEntryFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public LogEntryBuilder(){
            this(true);
    }
    public LogEntryBuilder(Boolean validationEnabled){
            this(new LogEntry(), validationEnabled);
    }
    public LogEntryBuilder(LogEntryFluent<?> fluent){
            this(fluent, true);
    }
    public LogEntryBuilder(LogEntryFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new LogEntry(), validationEnabled);
    }
    public LogEntryBuilder(LogEntryFluent<?> fluent,LogEntry instance){
            this(fluent, instance, true);
    }
    public LogEntryBuilder(LogEntryFluent<?> fluent,LogEntry instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public LogEntryBuilder(LogEntry instance){
            this(instance,true);
    }
    public LogEntryBuilder(LogEntry instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public LogEntryBuilder(Validator validator){
            this(new LogEntry(), true);
    }
    public LogEntryBuilder(LogEntryFluent<?> fluent,LogEntry instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public LogEntryBuilder(LogEntry instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public LogEntry build(){
            LogEntry buildable = new LogEntry(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LogEntryBuilder that = (LogEntryBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
