package me.snowdrop.istio.mixer.template.checknothing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class CheckNothingBuilder extends CheckNothingFluentImpl<CheckNothingBuilder> implements VisitableBuilder<CheckNothing,CheckNothingBuilder>{

    CheckNothingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CheckNothingBuilder(){
            this(true);
    }
    public CheckNothingBuilder(Boolean validationEnabled){
            this(new CheckNothing(), validationEnabled);
    }
    public CheckNothingBuilder(CheckNothingFluent<?> fluent){
            this(fluent, true);
    }
    public CheckNothingBuilder(CheckNothingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CheckNothing(), validationEnabled);
    }
    public CheckNothingBuilder(CheckNothingFluent<?> fluent,CheckNothing instance){
            this(fluent, instance, true);
    }
    public CheckNothingBuilder(CheckNothingFluent<?> fluent,CheckNothing instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckNothingBuilder(CheckNothing instance){
            this(instance,true);
    }
    public CheckNothingBuilder(CheckNothing instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public CheckNothingBuilder(Validator validator){
            this(new CheckNothing(), true);
    }
    public CheckNothingBuilder(CheckNothingFluent<?> fluent,CheckNothing instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public CheckNothingBuilder(CheckNothing instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public CheckNothing build(){
            CheckNothing buildable = new CheckNothing(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CheckNothingBuilder that = (CheckNothingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
