package me.snowdrop.istio.mixer.template.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class AuthorizationListBuilder extends AuthorizationListFluentImpl<AuthorizationListBuilder> implements VisitableBuilder<AuthorizationList,AuthorizationListBuilder>{

    AuthorizationListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AuthorizationListBuilder(){
            this(true);
    }
    public AuthorizationListBuilder(Boolean validationEnabled){
            this(new AuthorizationList(), validationEnabled);
    }
    public AuthorizationListBuilder(AuthorizationListFluent<?> fluent){
            this(fluent, true);
    }
    public AuthorizationListBuilder(AuthorizationListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AuthorizationList(), validationEnabled);
    }
    public AuthorizationListBuilder(AuthorizationListFluent<?> fluent,AuthorizationList instance){
            this(fluent, instance, true);
    }
    public AuthorizationListBuilder(AuthorizationListFluent<?> fluent,AuthorizationList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthorizationListBuilder(AuthorizationList instance){
            this(instance,true);
    }
    public AuthorizationListBuilder(AuthorizationList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthorizationListBuilder(Validator validator){
            this(new AuthorizationList(), true);
    }
    public AuthorizationListBuilder(AuthorizationListFluent<?> fluent,AuthorizationList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public AuthorizationListBuilder(AuthorizationList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public AuthorizationList build(){
            AuthorizationList buildable = new AuthorizationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthorizationListBuilder that = (AuthorizationListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
