package me.snowdrop.istio.mixer.template.apikey;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ApiKeySpecBuilder extends ApiKeySpecFluentImpl<ApiKeySpecBuilder> implements VisitableBuilder<ApiKeySpec,ApiKeySpecBuilder>{

    ApiKeySpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ApiKeySpecBuilder(){
            this(true);
    }
    public ApiKeySpecBuilder(Boolean validationEnabled){
            this(new ApiKeySpec(), validationEnabled);
    }
    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent){
            this(fluent, true);
    }
    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ApiKeySpec(), validationEnabled);
    }
    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent,ApiKeySpec instance){
            this(fluent, instance, true);
    }
    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent,ApiKeySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApi(instance.getApi()); 
            fluent.withApiKey(instance.getApiKey()); 
            fluent.withApiOperation(instance.getApiOperation()); 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withName(instance.getName()); 
            fluent.withTimestamp(instance.getTimestamp()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiKeySpecBuilder(ApiKeySpec instance){
            this(instance,true);
    }
    public ApiKeySpecBuilder(ApiKeySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApi(instance.getApi()); 
            this.withApiKey(instance.getApiKey()); 
            this.withApiOperation(instance.getApiOperation()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withName(instance.getName()); 
            this.withTimestamp(instance.getTimestamp()); 
            this.validationEnabled = validationEnabled; 
    }
    public ApiKeySpecBuilder(Validator validator){
            this(new ApiKeySpec(), true);
    }
    public ApiKeySpecBuilder(ApiKeySpecFluent<?> fluent,ApiKeySpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApi(instance.getApi()); 
            fluent.withApiKey(instance.getApiKey()); 
            fluent.withApiOperation(instance.getApiOperation()); 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withName(instance.getName()); 
            fluent.withTimestamp(instance.getTimestamp()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ApiKeySpecBuilder(ApiKeySpec instance,Validator validator){
            this.fluent = this; 
            this.withApi(instance.getApi()); 
            this.withApiKey(instance.getApiKey()); 
            this.withApiOperation(instance.getApiOperation()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withName(instance.getName()); 
            this.withTimestamp(instance.getTimestamp()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ApiKeySpec build(){
            ApiKeySpec buildable = new ApiKeySpec(fluent.getApi(),fluent.getApiKey(),fluent.getApiOperation(),fluent.getApiVersion(),fluent.getName(),fluent.getTimestamp());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ApiKeySpecBuilder that = (ApiKeySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
