package me.snowdrop.istio.mixer.adapter.stdio;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class StdioSpecBuilder extends StdioSpecFluentImpl<StdioSpecBuilder> implements VisitableBuilder<StdioSpec,StdioSpecBuilder>{

    StdioSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StdioSpecBuilder(){
            this(true);
    }
    public StdioSpecBuilder(Boolean validationEnabled){
            this(new StdioSpec(), validationEnabled);
    }
    public StdioSpecBuilder(StdioSpecFluent<?> fluent){
            this(fluent, true);
    }
    public StdioSpecBuilder(StdioSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StdioSpec(), validationEnabled);
    }
    public StdioSpecBuilder(StdioSpecFluent<?> fluent,StdioSpec instance){
            this(fluent, instance, true);
    }
    public StdioSpecBuilder(StdioSpecFluent<?> fluent,StdioSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLogStream(instance.getLogStream()); 
            fluent.withMaxDaysBeforeRotation(instance.getMaxDaysBeforeRotation()); 
            fluent.withMaxMegabytesBeforeRotation(instance.getMaxMegabytesBeforeRotation()); 
            fluent.withMaxRotatedFiles(instance.getMaxRotatedFiles()); 
            fluent.withMetricLevel(instance.getMetricLevel()); 
            fluent.withOutputAsJson(instance.getOutputAsJson()); 
            fluent.withOutputLevel(instance.getOutputLevel()); 
            fluent.withOutputPath(instance.getOutputPath()); 
            fluent.withSeverityLevels(instance.getSeverityLevels()); 
            this.validationEnabled = validationEnabled; 
    }
    public StdioSpecBuilder(StdioSpec instance){
            this(instance,true);
    }
    public StdioSpecBuilder(StdioSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLogStream(instance.getLogStream()); 
            this.withMaxDaysBeforeRotation(instance.getMaxDaysBeforeRotation()); 
            this.withMaxMegabytesBeforeRotation(instance.getMaxMegabytesBeforeRotation()); 
            this.withMaxRotatedFiles(instance.getMaxRotatedFiles()); 
            this.withMetricLevel(instance.getMetricLevel()); 
            this.withOutputAsJson(instance.getOutputAsJson()); 
            this.withOutputLevel(instance.getOutputLevel()); 
            this.withOutputPath(instance.getOutputPath()); 
            this.withSeverityLevels(instance.getSeverityLevels()); 
            this.validationEnabled = validationEnabled; 
    }
    public StdioSpecBuilder(Validator validator){
            this(new StdioSpec(), true);
    }
    public StdioSpecBuilder(StdioSpecFluent<?> fluent,StdioSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withLogStream(instance.getLogStream()); 
            fluent.withMaxDaysBeforeRotation(instance.getMaxDaysBeforeRotation()); 
            fluent.withMaxMegabytesBeforeRotation(instance.getMaxMegabytesBeforeRotation()); 
            fluent.withMaxRotatedFiles(instance.getMaxRotatedFiles()); 
            fluent.withMetricLevel(instance.getMetricLevel()); 
            fluent.withOutputAsJson(instance.getOutputAsJson()); 
            fluent.withOutputLevel(instance.getOutputLevel()); 
            fluent.withOutputPath(instance.getOutputPath()); 
            fluent.withSeverityLevels(instance.getSeverityLevels()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public StdioSpecBuilder(StdioSpec instance,Validator validator){
            this.fluent = this; 
            this.withLogStream(instance.getLogStream()); 
            this.withMaxDaysBeforeRotation(instance.getMaxDaysBeforeRotation()); 
            this.withMaxMegabytesBeforeRotation(instance.getMaxMegabytesBeforeRotation()); 
            this.withMaxRotatedFiles(instance.getMaxRotatedFiles()); 
            this.withMetricLevel(instance.getMetricLevel()); 
            this.withOutputAsJson(instance.getOutputAsJson()); 
            this.withOutputLevel(instance.getOutputLevel()); 
            this.withOutputPath(instance.getOutputPath()); 
            this.withSeverityLevels(instance.getSeverityLevels()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public StdioSpec build(){
            StdioSpec buildable = new StdioSpec(fluent.getLogStream(),fluent.getMaxDaysBeforeRotation(),fluent.getMaxMegabytesBeforeRotation(),fluent.getMaxRotatedFiles(),fluent.getMetricLevel(),fluent.isOutputAsJson(),fluent.getOutputLevel(),fluent.getOutputPath(),fluent.getSeverityLevels());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StdioSpecBuilder that = (StdioSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
