
package me.snowdrop.istio.mixer.adapter.stdio;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "logStream",
    "maxDaysBeforeRotation",
    "maxMegabytesBeforeRotation",
    "maxRotatedFiles",
    "metricLevel",
    "outputAsJson",
    "outputLevel",
    "outputPath",
    "severityLevels"
})
@IstioKind(name = "stdio", plural = "stdios")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class StdioSpec implements Serializable, IstioSpec
{

    @JsonProperty("logStream")
    private Stream logStream;
    /**
     * 
     * 
     */
    @JsonProperty("maxDaysBeforeRotation")
    @JsonPropertyDescription("")
    private java.lang.Integer maxDaysBeforeRotation;
    /**
     * 
     * 
     */
    @JsonProperty("maxMegabytesBeforeRotation")
    @JsonPropertyDescription("")
    private java.lang.Integer maxMegabytesBeforeRotation;
    /**
     * 
     * 
     */
    @JsonProperty("maxRotatedFiles")
    @JsonPropertyDescription("")
    private java.lang.Integer maxRotatedFiles;
    @JsonProperty("metricLevel")
    private me.snowdrop.istio.mixer.adapter.stdio.Level metricLevel;
    /**
     * 
     * 
     */
    @JsonProperty("outputAsJson")
    @JsonPropertyDescription("")
    private Boolean outputAsJson;
    @JsonProperty("outputLevel")
    private me.snowdrop.istio.mixer.adapter.stdio.Level outputLevel;
    /**
     * 
     * 
     */
    @JsonProperty("outputPath")
    @JsonPropertyDescription("")
    private java.lang.String outputPath;
    /**
     * 
     * 
     */
    @JsonProperty("severityLevels")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, Integer> severityLevels;
    private final static long serialVersionUID = -8128375591344772529L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StdioSpec() {
    }

    /**
     * 
     * @param maxDaysBeforeRotation
     * @param maxMegabytesBeforeRotation
     * @param maxRotatedFiles
     * @param outputPath
     * @param outputAsJson
     * @param logStream
     * @param outputLevel
     * @param metricLevel
     * @param severityLevels
     */
    public StdioSpec(Stream logStream, java.lang.Integer maxDaysBeforeRotation, java.lang.Integer maxMegabytesBeforeRotation, java.lang.Integer maxRotatedFiles, me.snowdrop.istio.mixer.adapter.stdio.Level metricLevel, Boolean outputAsJson, me.snowdrop.istio.mixer.adapter.stdio.Level outputLevel, java.lang.String outputPath, Map<String, Integer> severityLevels) {
        super();
        this.logStream = logStream;
        this.maxDaysBeforeRotation = maxDaysBeforeRotation;
        this.maxMegabytesBeforeRotation = maxMegabytesBeforeRotation;
        this.maxRotatedFiles = maxRotatedFiles;
        this.metricLevel = metricLevel;
        this.outputAsJson = outputAsJson;
        this.outputLevel = outputLevel;
        this.outputPath = outputPath;
        this.severityLevels = severityLevels;
    }

    @JsonProperty("logStream")
    public Stream getLogStream() {
        return logStream;
    }

    @JsonProperty("logStream")
    public void setLogStream(Stream logStream) {
        this.logStream = logStream;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxDaysBeforeRotation")
    public java.lang.Integer getMaxDaysBeforeRotation() {
        return maxDaysBeforeRotation;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxDaysBeforeRotation")
    public void setMaxDaysBeforeRotation(java.lang.Integer maxDaysBeforeRotation) {
        this.maxDaysBeforeRotation = maxDaysBeforeRotation;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxMegabytesBeforeRotation")
    public java.lang.Integer getMaxMegabytesBeforeRotation() {
        return maxMegabytesBeforeRotation;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxMegabytesBeforeRotation")
    public void setMaxMegabytesBeforeRotation(java.lang.Integer maxMegabytesBeforeRotation) {
        this.maxMegabytesBeforeRotation = maxMegabytesBeforeRotation;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxRotatedFiles")
    public java.lang.Integer getMaxRotatedFiles() {
        return maxRotatedFiles;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxRotatedFiles")
    public void setMaxRotatedFiles(java.lang.Integer maxRotatedFiles) {
        this.maxRotatedFiles = maxRotatedFiles;
    }

    @JsonProperty("metricLevel")
    public me.snowdrop.istio.mixer.adapter.stdio.Level getMetricLevel() {
        return metricLevel;
    }

    @JsonProperty("metricLevel")
    public void setMetricLevel(me.snowdrop.istio.mixer.adapter.stdio.Level metricLevel) {
        this.metricLevel = metricLevel;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outputAsJson")
    public Boolean getOutputAsJson() {
        return outputAsJson;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outputAsJson")
    public void setOutputAsJson(Boolean outputAsJson) {
        this.outputAsJson = outputAsJson;
    }

    @JsonProperty("outputLevel")
    public me.snowdrop.istio.mixer.adapter.stdio.Level getOutputLevel() {
        return outputLevel;
    }

    @JsonProperty("outputLevel")
    public void setOutputLevel(me.snowdrop.istio.mixer.adapter.stdio.Level outputLevel) {
        this.outputLevel = outputLevel;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outputPath")
    public java.lang.String getOutputPath() {
        return outputPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("outputPath")
    public void setOutputPath(java.lang.String outputPath) {
        this.outputPath = outputPath;
    }

    /**
     * 
     * 
     */
    @JsonProperty("severityLevels")
    public Map<String, Integer> getSeverityLevels() {
        return severityLevels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("severityLevels")
    public void setSeverityLevels(Map<String, Integer> severityLevels) {
        this.severityLevels = severityLevels;
    }

}
