package me.snowdrop.istio.mixer.adapter.stackdriver;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.lang.Double;

public class TraceFluentImpl<A extends TraceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TraceFluent<A>{

    private Double sampleProbability;

    public TraceFluentImpl(){
    }
    public TraceFluentImpl(Trace instance){
            this.withSampleProbability(instance.getSampleProbability()); 
    }

    public Double getSampleProbability(){
            return this.sampleProbability;
    }

    public A withSampleProbability(Double sampleProbability){
            this.sampleProbability=sampleProbability; return (A) this;
    }

    public Boolean hasSampleProbability(){
            return this.sampleProbability != null;
    }

    public A withNewSampleProbability(String arg1){
            return (A)withSampleProbability(new Double(arg1));
    }

    public A withNewSampleProbability(double arg1){
            return (A)withSampleProbability(new Double(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TraceFluentImpl that = (TraceFluentImpl) o;
            if (sampleProbability != null ? !sampleProbability.equals(that.sampleProbability) :that.sampleProbability != null) return false;
            return true;
    }




}
