package me.snowdrop.istio.mixer.adapter.solarwinds;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class MetricInfoFluentImpl<A extends me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfoFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfoFluent<A>{

    private List<String> labelNames;

    public MetricInfoFluentImpl(){
    }
    public MetricInfoFluentImpl(me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo instance){
            this.withLabelNames(instance.getLabelNames()); 
    }

    public A addToLabelNames(int index,String item){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            this.labelNames.add(index, item);
            return (A)this;
    }

    public A setToLabelNames(int index,String item){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            this.labelNames.set(index, item); return (A)this;
    }

    public A addToLabelNames(String... items){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            for (String item : items) {this.labelNames.add(item);} return (A)this;
    }

    public A addAllToLabelNames(Collection<String> items){
            if (this.labelNames == null) {this.labelNames = new ArrayList<String>();}
            for (String item : items) {this.labelNames.add(item);} return (A)this;
    }

    public A removeFromLabelNames(String... items){
            for (String item : items) {if (this.labelNames!= null){ this.labelNames.remove(item);}} return (A)this;
    }

    public A removeAllFromLabelNames(Collection<String> items){
            for (String item : items) {if (this.labelNames!= null){ this.labelNames.remove(item);}} return (A)this;
    }

    public List<String> getLabelNames(){
            return this.labelNames;
    }

    public String getLabelName(int index){
            return this.labelNames.get(index);
    }

    public String getFirstLabelName(){
            return this.labelNames.get(0);
    }

    public String getLastLabelName(){
            return this.labelNames.get(labelNames.size() - 1);
    }

    public String getMatchingLabelName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: labelNames) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withLabelNames(List<String> labelNames){
            if (this.labelNames != null) { _visitables.removeAll(this.labelNames);}
            if (labelNames != null) {this.labelNames = new ArrayList<String>(); for (String item : labelNames){this.addToLabelNames(item);}} else { this.labelNames = null;} return (A) this;
    }

    public A withLabelNames(String... labelNames){
            if (this.labelNames != null) {this.labelNames.clear();}
            if (labelNames != null) {for (String item :labelNames){ this.addToLabelNames(item);}} return (A) this;
    }

    public Boolean hasLabelNames(){
            return labelNames != null && !labelNames.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricInfoFluentImpl that = (MetricInfoFluentImpl) o;
            if (labelNames != null ? !labelNames.equals(that.labelNames) :that.labelNames != null) return false;
            return true;
    }




}
