
package me.snowdrop.istio.mixer.adapter.signalfx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "accessToken",
    "datapointInterval",
    "ingestUrl",
    "metrics"
})
@IstioKind(name = "signalfx", plural = "signalfxs")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class SignalfxSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("accessToken")
    @JsonPropertyDescription("")
    private String accessToken;
    /**
     * 
     * 
     */
    @JsonProperty("datapointInterval")
    @JsonPropertyDescription("")
    private Long datapointInterval;
    /**
     * 
     * 
     */
    @JsonProperty("ingestUrl")
    @JsonPropertyDescription("")
    private String ingestUrl;
    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    @Valid
    private List<MetricConfig> metrics = new ArrayList<MetricConfig>();
    private final static long serialVersionUID = -1773550810841176096L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SignalfxSpec() {
    }

    /**
     * 
     * @param ingestUrl
     * @param metrics
     * @param accessToken
     * @param datapointInterval
     */
    public SignalfxSpec(String accessToken, Long datapointInterval, String ingestUrl, List<MetricConfig> metrics) {
        super();
        this.accessToken = accessToken;
        this.datapointInterval = datapointInterval;
        this.ingestUrl = ingestUrl;
        this.metrics = metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessToken")
    public String getAccessToken() {
        return accessToken;
    }

    /**
     * 
     * 
     */
    @JsonProperty("accessToken")
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    /**
     * 
     * 
     */
    @JsonProperty("datapointInterval")
    public Long getDatapointInterval() {
        return datapointInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("datapointInterval")
    public void setDatapointInterval(Long datapointInterval) {
        this.datapointInterval = datapointInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingestUrl")
    public String getIngestUrl() {
        return ingestUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("ingestUrl")
    public void setIngestUrl(String ingestUrl) {
        this.ingestUrl = ingestUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public List<MetricConfig> getMetrics() {
        return metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public void setMetrics(List<MetricConfig> metrics) {
        this.metrics = metrics;
    }

}
