package me.snowdrop.istio.mixer.adapter.signalfx;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SignalfxListBuilder extends SignalfxListFluentImpl<SignalfxListBuilder> implements VisitableBuilder<SignalfxList,SignalfxListBuilder>{

    SignalfxListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SignalfxListBuilder(){
            this(true);
    }
    public SignalfxListBuilder(Boolean validationEnabled){
            this(new SignalfxList(), validationEnabled);
    }
    public SignalfxListBuilder(SignalfxListFluent<?> fluent){
            this(fluent, true);
    }
    public SignalfxListBuilder(SignalfxListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SignalfxList(), validationEnabled);
    }
    public SignalfxListBuilder(SignalfxListFluent<?> fluent,SignalfxList instance){
            this(fluent, instance, true);
    }
    public SignalfxListBuilder(SignalfxListFluent<?> fluent,SignalfxList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public SignalfxListBuilder(SignalfxList instance){
            this(instance,true);
    }
    public SignalfxListBuilder(SignalfxList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public SignalfxListBuilder(Validator validator){
            this(new SignalfxList(), true);
    }
    public SignalfxListBuilder(SignalfxListFluent<?> fluent,SignalfxList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SignalfxListBuilder(SignalfxList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SignalfxList build(){
            SignalfxList buildable = new SignalfxList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SignalfxListBuilder that = (SignalfxListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
