package me.snowdrop.istio.mixer.adapter.signalfx;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface SignalfxFluent<A extends SignalfxFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public SignalfxFluent.MetadataNested<A> withNewMetadata();
    public SignalfxFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public SignalfxFluent.MetadataNested<A> editMetadata();
    public SignalfxFluent.MetadataNested<A> editOrNewMetadata();
    public SignalfxFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public SignalfxSpec getSpec();
    public SignalfxSpec buildSpec();
    public A withSpec(SignalfxSpec spec);
    public Boolean hasSpec();
    public SignalfxFluent.SpecNested<A> withNewSpec();
    public SignalfxFluent.SpecNested<A> withNewSpecLike(SignalfxSpec item);
    public SignalfxFluent.SpecNested<A> editSpec();
    public SignalfxFluent.SpecNested<A> editOrNewSpec();
    public SignalfxFluent.SpecNested<A> editOrNewSpecLike(SignalfxSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<SignalfxFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,SignalfxSpecFluent<SignalfxFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
