package me.snowdrop.istio.mixer.adapter.servicecontrol;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class ServicecontrolSpecFluentImpl<A extends ServicecontrolSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServicecontrolSpecFluent<A>{

    private String credentialPath;
    private RuntimeConfigBuilder runtimeConfig;
    private List<GcpServiceSettingBuilder> serviceConfigs;

    public ServicecontrolSpecFluentImpl(){
    }
    public ServicecontrolSpecFluentImpl(ServicecontrolSpec instance){
            this.withCredentialPath(instance.getCredentialPath()); 
            this.withRuntimeConfig(instance.getRuntimeConfig()); 
            this.withServiceConfigs(instance.getServiceConfigs()); 
    }

    public String getCredentialPath(){
            return this.credentialPath;
    }

    public A withCredentialPath(String credentialPath){
            this.credentialPath=credentialPath; return (A) this;
    }

    public Boolean hasCredentialPath(){
            return this.credentialPath != null;
    }

    
/**
 * This method has been deprecated, please use method buildRuntimeConfig instead.
 * @return The buildable object.
 */
@Deprecated public RuntimeConfig getRuntimeConfig(){
            return this.runtimeConfig!=null?this.runtimeConfig.build():null;
    }

    public RuntimeConfig buildRuntimeConfig(){
            return this.runtimeConfig!=null?this.runtimeConfig.build():null;
    }

    public A withRuntimeConfig(RuntimeConfig runtimeConfig){
            _visitables.remove(this.runtimeConfig);
            if (runtimeConfig!=null){ this.runtimeConfig= new RuntimeConfigBuilder(runtimeConfig); _visitables.add(this.runtimeConfig);} return (A) this;
    }

    public Boolean hasRuntimeConfig(){
            return this.runtimeConfig != null;
    }

    public ServicecontrolSpecFluent.RuntimeConfigNested<A> withNewRuntimeConfig(){
            return new RuntimeConfigNestedImpl();
    }

    public ServicecontrolSpecFluent.RuntimeConfigNested<A> withNewRuntimeConfigLike(RuntimeConfig item){
            return new RuntimeConfigNestedImpl(item);
    }

    public ServicecontrolSpecFluent.RuntimeConfigNested<A> editRuntimeConfig(){
            return withNewRuntimeConfigLike(getRuntimeConfig());
    }

    public ServicecontrolSpecFluent.RuntimeConfigNested<A> editOrNewRuntimeConfig(){
            return withNewRuntimeConfigLike(getRuntimeConfig() != null ? getRuntimeConfig(): new RuntimeConfigBuilder().build());
    }

    public ServicecontrolSpecFluent.RuntimeConfigNested<A> editOrNewRuntimeConfigLike(RuntimeConfig item){
            return withNewRuntimeConfigLike(getRuntimeConfig() != null ? getRuntimeConfig(): item);
    }

    public A addToServiceConfigs(int index,GcpServiceSetting item){
            if (this.serviceConfigs == null) {this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>();}
            GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.serviceConfigs.add(index >= 0 ? index : serviceConfigs.size(), builder); return (A)this;
    }

    public A setToServiceConfigs(int index,GcpServiceSetting item){
            if (this.serviceConfigs == null) {this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>();}
            GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= serviceConfigs.size()) { serviceConfigs.add(builder); } else { serviceConfigs.set(index, builder);}
             return (A)this;
    }

    public A addToServiceConfigs(GcpServiceSetting... items){
            if (this.serviceConfigs == null) {this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>();}
            for (GcpServiceSetting item : items) {GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);_visitables.add(builder);this.serviceConfigs.add(builder);} return (A)this;
    }

    public A addAllToServiceConfigs(Collection<GcpServiceSetting> items){
            if (this.serviceConfigs == null) {this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>();}
            for (GcpServiceSetting item : items) {GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);_visitables.add(builder);this.serviceConfigs.add(builder);} return (A)this;
    }

    public A removeFromServiceConfigs(GcpServiceSetting... items){
            for (GcpServiceSetting item : items) {GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);_visitables.remove(builder);if (this.serviceConfigs != null) {this.serviceConfigs.remove(builder);}} return (A)this;
    }

    public A removeAllFromServiceConfigs(Collection<GcpServiceSetting> items){
            for (GcpServiceSetting item : items) {GcpServiceSettingBuilder builder = new GcpServiceSettingBuilder(item);_visitables.remove(builder);if (this.serviceConfigs != null) {this.serviceConfigs.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildServiceConfigs instead.
 * @return The buildable object.
 */
@Deprecated public List<GcpServiceSetting> getServiceConfigs(){
            return build(serviceConfigs);
    }

    public List<GcpServiceSetting> buildServiceConfigs(){
            return build(serviceConfigs);
    }

    public GcpServiceSetting buildServiceConfig(int index){
            return this.serviceConfigs.get(index).build();
    }

    public GcpServiceSetting buildFirstServiceConfig(){
            return this.serviceConfigs.get(0).build();
    }

    public GcpServiceSetting buildLastServiceConfig(){
            return this.serviceConfigs.get(serviceConfigs.size() - 1).build();
    }

    public GcpServiceSetting buildMatchingServiceConfig(io.fabric8.kubernetes.api.builder.Predicate<GcpServiceSettingBuilder> predicate){
            for (GcpServiceSettingBuilder item: serviceConfigs) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withServiceConfigs(List<GcpServiceSetting> serviceConfigs){
            if (this.serviceConfigs != null) { _visitables.removeAll(this.serviceConfigs);}
            if (serviceConfigs != null) {this.serviceConfigs = new ArrayList<GcpServiceSettingBuilder>(); for (GcpServiceSetting item : serviceConfigs){this.addToServiceConfigs(item);}} else { this.serviceConfigs = null;} return (A) this;
    }

    public A withServiceConfigs(GcpServiceSetting... serviceConfigs){
            if (this.serviceConfigs != null) {this.serviceConfigs.clear();}
            if (serviceConfigs != null) {for (GcpServiceSetting item :serviceConfigs){ this.addToServiceConfigs(item);}} return (A) this;
    }

    public Boolean hasServiceConfigs(){
            return serviceConfigs != null && !serviceConfigs.isEmpty();
    }

    public ServicecontrolSpecFluent.ServiceConfigsNested<A> addNewServiceConfig(){
            return new ServiceConfigsNestedImpl();
    }

    public ServicecontrolSpecFluent.ServiceConfigsNested<A> addNewServiceConfigLike(GcpServiceSetting item){
            return new ServiceConfigsNestedImpl(-1, item);
    }

    public ServicecontrolSpecFluent.ServiceConfigsNested<A> setNewServiceConfigLike(int index,GcpServiceSetting item){
            return new ServiceConfigsNestedImpl(index, item);
    }

    public ServicecontrolSpecFluent.ServiceConfigsNested<A> editServiceConfig(int index){
            if (serviceConfigs.size() <= index) throw new RuntimeException("Can't edit serviceConfigs. Index exceeds size.");
            return setNewServiceConfigLike(index, buildServiceConfig(index));
    }

    public ServicecontrolSpecFluent.ServiceConfigsNested<A> editFirstServiceConfig(){
            if (serviceConfigs.size() == 0) throw new RuntimeException("Can't edit first serviceConfigs. The list is empty.");
            return setNewServiceConfigLike(0, buildServiceConfig(0));
    }

    public ServicecontrolSpecFluent.ServiceConfigsNested<A> editLastServiceConfig(){
            int index = serviceConfigs.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last serviceConfigs. The list is empty.");
            return setNewServiceConfigLike(index, buildServiceConfig(index));
    }

    public ServicecontrolSpecFluent.ServiceConfigsNested<A> editMatchingServiceConfig(io.fabric8.kubernetes.api.builder.Predicate<GcpServiceSettingBuilder> predicate){
            int index = -1;
            for (int i=0;i<serviceConfigs.size();i++) { 
            if (predicate.apply(serviceConfigs.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching serviceConfigs. No match found.");
            return setNewServiceConfigLike(index, buildServiceConfig(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServicecontrolSpecFluentImpl that = (ServicecontrolSpecFluentImpl) o;
            if (credentialPath != null ? !credentialPath.equals(that.credentialPath) :that.credentialPath != null) return false;
            if (runtimeConfig != null ? !runtimeConfig.equals(that.runtimeConfig) :that.runtimeConfig != null) return false;
            if (serviceConfigs != null ? !serviceConfigs.equals(that.serviceConfigs) :that.serviceConfigs != null) return false;
            return true;
    }


    public class RuntimeConfigNestedImpl<N> extends RuntimeConfigFluentImpl<ServicecontrolSpecFluent.RuntimeConfigNested<N>> implements ServicecontrolSpecFluent.RuntimeConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RuntimeConfigBuilder builder;
    
            RuntimeConfigNestedImpl(RuntimeConfig item){
                    this.builder = new RuntimeConfigBuilder(this, item);
            }
            RuntimeConfigNestedImpl(){
                    this.builder = new RuntimeConfigBuilder(this);
            }
    
    public N and(){
            return (N) ServicecontrolSpecFluentImpl.this.withRuntimeConfig(builder.build());
    }
    public N endRuntimeConfig(){
            return and();
    }

}
    public class ServiceConfigsNestedImpl<N> extends GcpServiceSettingFluentImpl<ServicecontrolSpecFluent.ServiceConfigsNested<N>> implements ServicecontrolSpecFluent.ServiceConfigsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GcpServiceSettingBuilder builder;
        private final int index;
    
            ServiceConfigsNestedImpl(int index,GcpServiceSetting item){
                    this.index = index;
                    this.builder = new GcpServiceSettingBuilder(this, item);
            }
            ServiceConfigsNestedImpl(){
                    this.index = -1;
                    this.builder = new GcpServiceSettingBuilder(this);
            }
    
    public N and(){
            return (N) ServicecontrolSpecFluentImpl.this.setToServiceConfigs(index, builder.build());
    }
    public N endServiceConfig(){
            return and();
    }

}


}
