package me.snowdrop.istio.mixer.adapter.servicecontrol;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class QuotaFluentImpl<A extends me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluent<A>{

    private DurationBuilder expiration;
    private String googleQuotaMetricName;
    private String name;

    public QuotaFluentImpl(){
    }
    public QuotaFluentImpl(me.snowdrop.istio.mixer.adapter.servicecontrol.Quota instance){
            this.withExpiration(instance.getExpiration()); 
            this.withGoogleQuotaMetricName(instance.getGoogleQuotaMetricName()); 
            this.withName(instance.getName()); 
    }

    
/**
 * This method has been deprecated, please use method buildExpiration instead.
 * @return The buildable object.
 */
@Deprecated public Duration getExpiration(){
            return this.expiration!=null?this.expiration.build():null;
    }

    public Duration buildExpiration(){
            return this.expiration!=null?this.expiration.build():null;
    }

    public A withExpiration(Duration expiration){
            _visitables.remove(this.expiration);
            if (expiration!=null){ this.expiration= new DurationBuilder(expiration); _visitables.add(this.expiration);} return (A) this;
    }

    public Boolean hasExpiration(){
            return this.expiration != null;
    }

    public A withNewExpiration(Integer nanos,Long seconds){
            return (A)withExpiration(new Duration(nanos, seconds));
    }

    public QuotaFluent.ExpirationNested<A> withNewExpiration(){
            return new ExpirationNestedImpl();
    }

    public QuotaFluent.ExpirationNested<A> withNewExpirationLike(Duration item){
            return new ExpirationNestedImpl(item);
    }

    public QuotaFluent.ExpirationNested<A> editExpiration(){
            return withNewExpirationLike(getExpiration());
    }

    public QuotaFluent.ExpirationNested<A> editOrNewExpiration(){
            return withNewExpirationLike(getExpiration() != null ? getExpiration(): new DurationBuilder().build());
    }

    public QuotaFluent.ExpirationNested<A> editOrNewExpirationLike(Duration item){
            return withNewExpirationLike(getExpiration() != null ? getExpiration(): item);
    }

    public String getGoogleQuotaMetricName(){
            return this.googleQuotaMetricName;
    }

    public A withGoogleQuotaMetricName(String googleQuotaMetricName){
            this.googleQuotaMetricName=googleQuotaMetricName; return (A) this;
    }

    public Boolean hasGoogleQuotaMetricName(){
            return this.googleQuotaMetricName != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaFluentImpl that = (QuotaFluentImpl) o;
            if (expiration != null ? !expiration.equals(that.expiration) :that.expiration != null) return false;
            if (googleQuotaMetricName != null ? !googleQuotaMetricName.equals(that.googleQuotaMetricName) :that.googleQuotaMetricName != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }


    public class ExpirationNestedImpl<N> extends DurationFluentImpl<QuotaFluent.ExpirationNested<N>> implements QuotaFluent.ExpirationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ExpirationNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ExpirationNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) QuotaFluentImpl.this.withExpiration(builder.build());
    }
    public N endExpiration(){
            return and();
    }

}


}
