package me.snowdrop.istio.mixer.adapter.servicecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class QuotaBuilder extends me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluentImpl<me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder> implements VisitableBuilder<me.snowdrop.istio.mixer.adapter.servicecontrol.Quota,me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder>{

    me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public QuotaBuilder(){
            this(true);
    }
    public QuotaBuilder(Boolean validationEnabled){
            this(new Quota(), validationEnabled);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluent<?> fluent){
            this(fluent, true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Quota(), validationEnabled);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluent<?> fluent,me.snowdrop.istio.mixer.adapter.servicecontrol.Quota instance){
            this(fluent, instance, true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluent<?> fluent,me.snowdrop.istio.mixer.adapter.servicecontrol.Quota instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExpiration(instance.getExpiration()); 
            fluent.withGoogleQuotaMetricName(instance.getGoogleQuotaMetricName()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.servicecontrol.Quota instance){
            this(instance,true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.servicecontrol.Quota instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExpiration(instance.getExpiration()); 
            this.withGoogleQuotaMetricName(instance.getGoogleQuotaMetricName()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public QuotaBuilder(Validator validator){
            this(new Quota(), true);
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluent<?> fluent,me.snowdrop.istio.mixer.adapter.servicecontrol.Quota instance,Validator validator){
            this.fluent = fluent; 
            fluent.withExpiration(instance.getExpiration()); 
            fluent.withGoogleQuotaMetricName(instance.getGoogleQuotaMetricName()); 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public QuotaBuilder(me.snowdrop.istio.mixer.adapter.servicecontrol.Quota instance,Validator validator){
            this.fluent = this; 
            this.withExpiration(instance.getExpiration()); 
            this.withGoogleQuotaMetricName(instance.getGoogleQuotaMetricName()); 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public me.snowdrop.istio.mixer.adapter.servicecontrol.Quota build(){
            Quota buildable = new Quota(fluent.getExpiration(),fluent.getGoogleQuotaMetricName(),fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            QuotaBuilder that = (QuotaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
