
package me.snowdrop.istio.mixer.adapter.servicecontrol;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "expiration",
    "googleQuotaMetricName",
    "name"
})
@IstioKind(name = "quota", plural = "quotas")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Quota implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("expiration")
    @JsonPropertyDescription("")
    @Valid
    private Duration expiration;
    /**
     * 
     * 
     */
    @JsonProperty("googleQuotaMetricName")
    @JsonPropertyDescription("")
    private String googleQuotaMetricName;
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    private final static long serialVersionUID = 3261612614072748361L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Quota() {
    }

    /**
     * 
     * @param googleQuotaMetricName
     * @param name
     * @param expiration
     */
    public Quota(Duration expiration, String googleQuotaMetricName, String name) {
        super();
        this.expiration = expiration;
        this.googleQuotaMetricName = googleQuotaMetricName;
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("expiration")
    public Duration getExpiration() {
        return expiration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("expiration")
    public void setExpiration(Duration expiration) {
        this.expiration = expiration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("googleQuotaMetricName")
    public String getGoogleQuotaMetricName() {
        return googleQuotaMetricName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("googleQuotaMetricName")
    public void setGoogleQuotaMetricName(String googleQuotaMetricName) {
        this.googleQuotaMetricName = googleQuotaMetricName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

}
