package me.snowdrop.istio.mixer.adapter.redisquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class RedisquotaSpecBuilder extends RedisquotaSpecFluentImpl<RedisquotaSpecBuilder> implements VisitableBuilder<RedisquotaSpec,RedisquotaSpecBuilder>{

    RedisquotaSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RedisquotaSpecBuilder(){
            this(true);
    }
    public RedisquotaSpecBuilder(Boolean validationEnabled){
            this(new RedisquotaSpec(), validationEnabled);
    }
    public RedisquotaSpecBuilder(RedisquotaSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RedisquotaSpecBuilder(RedisquotaSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RedisquotaSpec(), validationEnabled);
    }
    public RedisquotaSpecBuilder(RedisquotaSpecFluent<?> fluent,RedisquotaSpec instance){
            this(fluent, instance, true);
    }
    public RedisquotaSpecBuilder(RedisquotaSpecFluent<?> fluent,RedisquotaSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConnectionPoolSize(instance.getConnectionPoolSize()); 
            fluent.withQuotas(instance.getQuotas()); 
            fluent.withRedisServerUrl(instance.getRedisServerUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public RedisquotaSpecBuilder(RedisquotaSpec instance){
            this(instance,true);
    }
    public RedisquotaSpecBuilder(RedisquotaSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConnectionPoolSize(instance.getConnectionPoolSize()); 
            this.withQuotas(instance.getQuotas()); 
            this.withRedisServerUrl(instance.getRedisServerUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public RedisquotaSpecBuilder(Validator validator){
            this(new RedisquotaSpec(), true);
    }
    public RedisquotaSpecBuilder(RedisquotaSpecFluent<?> fluent,RedisquotaSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withConnectionPoolSize(instance.getConnectionPoolSize()); 
            fluent.withQuotas(instance.getQuotas()); 
            fluent.withRedisServerUrl(instance.getRedisServerUrl()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public RedisquotaSpecBuilder(RedisquotaSpec instance,Validator validator){
            this.fluent = this; 
            this.withConnectionPoolSize(instance.getConnectionPoolSize()); 
            this.withQuotas(instance.getQuotas()); 
            this.withRedisServerUrl(instance.getRedisServerUrl()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public RedisquotaSpec build(){
            RedisquotaSpec buildable = new RedisquotaSpec(fluent.getConnectionPoolSize(),fluent.getQuotas(),fluent.getRedisServerUrl());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RedisquotaSpecBuilder that = (RedisquotaSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
