package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class LinearBuilder extends LinearFluentImpl<LinearBuilder> implements VisitableBuilder<Linear,LinearBuilder>{

    LinearFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public LinearBuilder(){
            this(true);
    }
    public LinearBuilder(Boolean validationEnabled){
            this(new Linear(), validationEnabled);
    }
    public LinearBuilder(LinearFluent<?> fluent){
            this(fluent, true);
    }
    public LinearBuilder(LinearFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Linear(), validationEnabled);
    }
    public LinearBuilder(LinearFluent<?> fluent,Linear instance){
            this(fluent, instance, true);
    }
    public LinearBuilder(LinearFluent<?> fluent,Linear instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNumFiniteBuckets(instance.getNumFiniteBuckets()); 
            fluent.withOffset(instance.getOffset()); 
            fluent.withWidth(instance.getWidth()); 
            this.validationEnabled = validationEnabled; 
    }
    public LinearBuilder(Linear instance){
            this(instance,true);
    }
    public LinearBuilder(Linear instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNumFiniteBuckets(instance.getNumFiniteBuckets()); 
            this.withOffset(instance.getOffset()); 
            this.withWidth(instance.getWidth()); 
            this.validationEnabled = validationEnabled; 
    }
    public LinearBuilder(Validator validator){
            this(new Linear(), true);
    }
    public LinearBuilder(LinearFluent<?> fluent,Linear instance,Validator validator){
            this.fluent = fluent; 
            fluent.withNumFiniteBuckets(instance.getNumFiniteBuckets()); 
            fluent.withOffset(instance.getOffset()); 
            fluent.withWidth(instance.getWidth()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public LinearBuilder(Linear instance,Validator validator){
            this.fluent = this; 
            this.withNumFiniteBuckets(instance.getNumFiniteBuckets()); 
            this.withOffset(instance.getOffset()); 
            this.withWidth(instance.getWidth()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Linear build(){
            Linear buildable = new Linear(fluent.getNumFiniteBuckets(),fluent.getOffset(),fluent.getWidth());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            LinearBuilder that = (LinearBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
