package me.snowdrop.istio.mixer.adapter.prometheus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.lang.Double;
import io.fabric8.kubernetes.api.builder.Predicate;

public interface ExplicitFluent<A extends ExplicitFluent<A>> extends Fluent<A>{


    public A addToBounds(int index,Double item);
    public A setToBounds(int index,Double item);
    public A addToBounds(Double... items);
    public A addAllToBounds(Collection<Double> items);
    public A removeFromBounds(Double... items);
    public A removeAllFromBounds(Collection<Double> items);
    public List<Double> getBounds();
    public Double getBound(int index);
    public Double getFirstBound();
    public Double getLastBound();
    public Double getMatchingBound(io.fabric8.kubernetes.api.builder.Predicate<Double> predicate);
    public A withBounds(List<Double> bounds);
    public A withBounds(Double... bounds);
    public Boolean hasBounds();
    public A addNewBound(String arg1);
    public A addNewBound(double arg1);



}
