package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class BucketsDefinitionBuilder extends BucketsDefinitionFluentImpl<BucketsDefinitionBuilder> implements VisitableBuilder<BucketsDefinition,BucketsDefinitionBuilder>{

    BucketsDefinitionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BucketsDefinitionBuilder(){
            this(true);
    }
    public BucketsDefinitionBuilder(Boolean validationEnabled){
            this(new BucketsDefinition(), validationEnabled);
    }
    public BucketsDefinitionBuilder(BucketsDefinitionFluent<?> fluent){
            this(fluent, true);
    }
    public BucketsDefinitionBuilder(BucketsDefinitionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BucketsDefinition(), validationEnabled);
    }
    public BucketsDefinitionBuilder(BucketsDefinitionFluent<?> fluent,BucketsDefinition instance){
            this(fluent, instance, true);
    }
    public BucketsDefinitionBuilder(BucketsDefinitionFluent<?> fluent,BucketsDefinition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefinition(instance.getDefinition()); 
            this.validationEnabled = validationEnabled; 
    }
    public BucketsDefinitionBuilder(BucketsDefinition instance){
            this(instance,true);
    }
    public BucketsDefinitionBuilder(BucketsDefinition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefinition(instance.getDefinition()); 
            this.validationEnabled = validationEnabled; 
    }
    public BucketsDefinitionBuilder(Validator validator){
            this(new BucketsDefinition(), true);
    }
    public BucketsDefinitionBuilder(BucketsDefinitionFluent<?> fluent,BucketsDefinition instance,Validator validator){
            this.fluent = fluent; 
            fluent.withDefinition(instance.getDefinition()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public BucketsDefinitionBuilder(BucketsDefinition instance,Validator validator){
            this.fluent = this; 
            this.withDefinition(instance.getDefinition()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public BucketsDefinition build(){
            BucketsDefinition buildable = new BucketsDefinition(fluent.getDefinition());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BucketsDefinitionBuilder that = (BucketsDefinitionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
