package me.snowdrop.istio.mixer.adapter.opa;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class OpaSpecBuilder extends OpaSpecFluentImpl<OpaSpecBuilder> implements VisitableBuilder<OpaSpec,OpaSpecBuilder>{

    OpaSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OpaSpecBuilder(){
            this(true);
    }
    public OpaSpecBuilder(Boolean validationEnabled){
            this(new OpaSpec(), validationEnabled);
    }
    public OpaSpecBuilder(OpaSpecFluent<?> fluent){
            this(fluent, true);
    }
    public OpaSpecBuilder(OpaSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OpaSpec(), validationEnabled);
    }
    public OpaSpecBuilder(OpaSpecFluent<?> fluent,OpaSpec instance){
            this(fluent, instance, true);
    }
    public OpaSpecBuilder(OpaSpecFluent<?> fluent,OpaSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCheckMethod(instance.getCheckMethod()); 
            fluent.withFailClose(instance.getFailClose()); 
            fluent.withPolicy(instance.getPolicy()); 
            this.validationEnabled = validationEnabled; 
    }
    public OpaSpecBuilder(OpaSpec instance){
            this(instance,true);
    }
    public OpaSpecBuilder(OpaSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCheckMethod(instance.getCheckMethod()); 
            this.withFailClose(instance.getFailClose()); 
            this.withPolicy(instance.getPolicy()); 
            this.validationEnabled = validationEnabled; 
    }
    public OpaSpecBuilder(Validator validator){
            this(new OpaSpec(), true);
    }
    public OpaSpecBuilder(OpaSpecFluent<?> fluent,OpaSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withCheckMethod(instance.getCheckMethod()); 
            fluent.withFailClose(instance.getFailClose()); 
            fluent.withPolicy(instance.getPolicy()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public OpaSpecBuilder(OpaSpec instance,Validator validator){
            this.fluent = this; 
            this.withCheckMethod(instance.getCheckMethod()); 
            this.withFailClose(instance.getFailClose()); 
            this.withPolicy(instance.getPolicy()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public OpaSpec build(){
            OpaSpec buildable = new OpaSpec(fluent.getCheckMethod(),fluent.isFailClose(),fluent.getPolicy());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OpaSpecBuilder that = (OpaSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
