package me.snowdrop.istio.mixer.adapter.memquota;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class MemquotaSpecBuilder extends MemquotaSpecFluentImpl<MemquotaSpecBuilder> implements VisitableBuilder<MemquotaSpec,MemquotaSpecBuilder>{

    MemquotaSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MemquotaSpecBuilder(){
            this(true);
    }
    public MemquotaSpecBuilder(Boolean validationEnabled){
            this(new MemquotaSpec(), validationEnabled);
    }
    public MemquotaSpecBuilder(MemquotaSpecFluent<?> fluent){
            this(fluent, true);
    }
    public MemquotaSpecBuilder(MemquotaSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MemquotaSpec(), validationEnabled);
    }
    public MemquotaSpecBuilder(MemquotaSpecFluent<?> fluent,MemquotaSpec instance){
            this(fluent, instance, true);
    }
    public MemquotaSpecBuilder(MemquotaSpecFluent<?> fluent,MemquotaSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMinDeduplicationDuration(instance.getMinDeduplicationDuration()); 
            fluent.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }
    public MemquotaSpecBuilder(MemquotaSpec instance){
            this(instance,true);
    }
    public MemquotaSpecBuilder(MemquotaSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMinDeduplicationDuration(instance.getMinDeduplicationDuration()); 
            this.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }
    public MemquotaSpecBuilder(Validator validator){
            this(new MemquotaSpec(), true);
    }
    public MemquotaSpecBuilder(MemquotaSpecFluent<?> fluent,MemquotaSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withMinDeduplicationDuration(instance.getMinDeduplicationDuration()); 
            fluent.withQuotas(instance.getQuotas()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public MemquotaSpecBuilder(MemquotaSpec instance,Validator validator){
            this.fluent = this; 
            this.withMinDeduplicationDuration(instance.getMinDeduplicationDuration()); 
            this.withQuotas(instance.getQuotas()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public MemquotaSpec build(){
            MemquotaSpec buildable = new MemquotaSpec(fluent.getMinDeduplicationDuration(),fluent.getQuotas());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MemquotaSpecBuilder that = (MemquotaSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
