package me.snowdrop.istio.mixer.adapter.memquota;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface MemquotaListFluent<A extends MemquotaListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Memquota item);
    public A setToItems(int index,Memquota item);
    public A addToItems(Memquota... items);
    public A addAllToItems(Collection<Memquota> items);
    public A removeFromItems(Memquota... items);
    public A removeAllFromItems(Collection<Memquota> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Memquota> getItems();
    public List<Memquota> buildItems();
    public Memquota buildItem(int index);
    public Memquota buildFirstItem();
    public Memquota buildLastItem();
    public Memquota buildMatchingItem(Predicate<MemquotaBuilder> predicate);
    public A withItems(List<Memquota> items);
    public A withItems(Memquota... items);
    public Boolean hasItems();
    public MemquotaListFluent.ItemsNested<A> addNewItem();
    public MemquotaListFluent.ItemsNested<A> addNewItemLike(Memquota item);
    public MemquotaListFluent.ItemsNested<A> setNewItemLike(int index,Memquota item);
    public MemquotaListFluent.ItemsNested<A> editItem(int index);
    public MemquotaListFluent.ItemsNested<A> editFirstItem();
    public MemquotaListFluent.ItemsNested<A> editLastItem();
    public MemquotaListFluent.ItemsNested<A> editMatchingItem(Predicate<MemquotaBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,MemquotaFluent<MemquotaListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
