package me.snowdrop.istio.mixer.adapter.list;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class BaseKubernetesListFluentImpl<A extends BaseKubernetesListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BaseKubernetesListFluent<A>{

    private Boolean blacklist;
    private Long cachingInterval;
    private Integer cachingUseCount;
    private ListEntryType entryType;
    private List<String> overrides;
    private String providerUrl;
    private Long refreshInterval;
    private Long ttl;

    public BaseKubernetesListFluentImpl(){
    }
    public BaseKubernetesListFluentImpl(BaseKubernetesList instance){
            this.withBlacklist(instance.getBlacklist()); 
            this.withCachingInterval(instance.getCachingInterval()); 
            this.withCachingUseCount(instance.getCachingUseCount()); 
            this.withEntryType(instance.getEntryType()); 
            this.withOverrides(instance.getOverrides()); 
            this.withProviderUrl(instance.getProviderUrl()); 
            this.withRefreshInterval(instance.getRefreshInterval()); 
            this.withTtl(instance.getTtl()); 
    }

    public Boolean isBlacklist(){
            return this.blacklist;
    }

    public A withBlacklist(Boolean blacklist){
            this.blacklist=blacklist; return (A) this;
    }

    public Boolean hasBlacklist(){
            return this.blacklist != null;
    }

    public A withNewBlacklist(String arg1){
            return (A)withBlacklist(new Boolean(arg1));
    }

    public A withNewBlacklist(boolean arg1){
            return (A)withBlacklist(new Boolean(arg1));
    }

    public Long getCachingInterval(){
            return this.cachingInterval;
    }

    public A withCachingInterval(Long cachingInterval){
            this.cachingInterval=cachingInterval; return (A) this;
    }

    public Boolean hasCachingInterval(){
            return this.cachingInterval != null;
    }

    public A withNewCachingInterval(String arg1){
            return (A)withCachingInterval(new Long(arg1));
    }

    public A withNewCachingInterval(long arg1){
            return (A)withCachingInterval(new Long(arg1));
    }

    public Integer getCachingUseCount(){
            return this.cachingUseCount;
    }

    public A withCachingUseCount(Integer cachingUseCount){
            this.cachingUseCount=cachingUseCount; return (A) this;
    }

    public Boolean hasCachingUseCount(){
            return this.cachingUseCount != null;
    }

    public A withNewCachingUseCount(String arg1){
            return (A)withCachingUseCount(new Integer(arg1));
    }

    public A withNewCachingUseCount(int arg1){
            return (A)withCachingUseCount(new Integer(arg1));
    }

    public ListEntryType getEntryType(){
            return this.entryType;
    }

    public A withEntryType(ListEntryType entryType){
            this.entryType=entryType; return (A) this;
    }

    public Boolean hasEntryType(){
            return this.entryType != null;
    }

    public A addToOverrides(int index,String item){
            if (this.overrides == null) {this.overrides = new ArrayList<String>();}
            this.overrides.add(index, item);
            return (A)this;
    }

    public A setToOverrides(int index,String item){
            if (this.overrides == null) {this.overrides = new ArrayList<String>();}
            this.overrides.set(index, item); return (A)this;
    }

    public A addToOverrides(String... items){
            if (this.overrides == null) {this.overrides = new ArrayList<String>();}
            for (String item : items) {this.overrides.add(item);} return (A)this;
    }

    public A addAllToOverrides(Collection<String> items){
            if (this.overrides == null) {this.overrides = new ArrayList<String>();}
            for (String item : items) {this.overrides.add(item);} return (A)this;
    }

    public A removeFromOverrides(String... items){
            for (String item : items) {if (this.overrides!= null){ this.overrides.remove(item);}} return (A)this;
    }

    public A removeAllFromOverrides(Collection<String> items){
            for (String item : items) {if (this.overrides!= null){ this.overrides.remove(item);}} return (A)this;
    }

    public List<String> getOverrides(){
            return this.overrides;
    }

    public String getOverride(int index){
            return this.overrides.get(index);
    }

    public String getFirstOverride(){
            return this.overrides.get(0);
    }

    public String getLastOverride(){
            return this.overrides.get(overrides.size() - 1);
    }

    public String getMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: overrides) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withOverrides(List<String> overrides){
            if (this.overrides != null) { _visitables.removeAll(this.overrides);}
            if (overrides != null) {this.overrides = new ArrayList<String>(); for (String item : overrides){this.addToOverrides(item);}} else { this.overrides = null;} return (A) this;
    }

    public A withOverrides(String... overrides){
            if (this.overrides != null) {this.overrides.clear();}
            if (overrides != null) {for (String item :overrides){ this.addToOverrides(item);}} return (A) this;
    }

    public Boolean hasOverrides(){
            return overrides != null && !overrides.isEmpty();
    }

    public String getProviderUrl(){
            return this.providerUrl;
    }

    public A withProviderUrl(String providerUrl){
            this.providerUrl=providerUrl; return (A) this;
    }

    public Boolean hasProviderUrl(){
            return this.providerUrl != null;
    }

    public Long getRefreshInterval(){
            return this.refreshInterval;
    }

    public A withRefreshInterval(Long refreshInterval){
            this.refreshInterval=refreshInterval; return (A) this;
    }

    public Boolean hasRefreshInterval(){
            return this.refreshInterval != null;
    }

    public A withNewRefreshInterval(String arg1){
            return (A)withRefreshInterval(new Long(arg1));
    }

    public A withNewRefreshInterval(long arg1){
            return (A)withRefreshInterval(new Long(arg1));
    }

    public Long getTtl(){
            return this.ttl;
    }

    public A withTtl(Long ttl){
            this.ttl=ttl; return (A) this;
    }

    public Boolean hasTtl(){
            return this.ttl != null;
    }

    public A withNewTtl(String arg1){
            return (A)withTtl(new Long(arg1));
    }

    public A withNewTtl(long arg1){
            return (A)withTtl(new Long(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BaseKubernetesListFluentImpl that = (BaseKubernetesListFluentImpl) o;
            if (blacklist != null ? !blacklist.equals(that.blacklist) :that.blacklist != null) return false;
            if (cachingInterval != null ? !cachingInterval.equals(that.cachingInterval) :that.cachingInterval != null) return false;
            if (cachingUseCount != null ? !cachingUseCount.equals(that.cachingUseCount) :that.cachingUseCount != null) return false;
            if (entryType != null ? !entryType.equals(that.entryType) :that.entryType != null) return false;
            if (overrides != null ? !overrides.equals(that.overrides) :that.overrides != null) return false;
            if (providerUrl != null ? !providerUrl.equals(that.providerUrl) :that.providerUrl != null) return false;
            if (refreshInterval != null ? !refreshInterval.equals(that.refreshInterval) :that.refreshInterval != null) return false;
            if (ttl != null ? !ttl.equals(that.ttl) :that.ttl != null) return false;
            return true;
    }




}
