package me.snowdrop.istio.mixer.adapter.fluentd;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface FluentdListFluent<A extends FluentdListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Fluentd item);
    public A setToItems(int index,Fluentd item);
    public A addToItems(Fluentd... items);
    public A addAllToItems(Collection<Fluentd> items);
    public A removeFromItems(Fluentd... items);
    public A removeAllFromItems(Collection<Fluentd> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Fluentd> getItems();
    public List<Fluentd> buildItems();
    public Fluentd buildItem(int index);
    public Fluentd buildFirstItem();
    public Fluentd buildLastItem();
    public Fluentd buildMatchingItem(Predicate<FluentdBuilder> predicate);
    public A withItems(List<Fluentd> items);
    public A withItems(Fluentd... items);
    public Boolean hasItems();
    public FluentdListFluent.ItemsNested<A> addNewItem();
    public FluentdListFluent.ItemsNested<A> addNewItemLike(Fluentd item);
    public FluentdListFluent.ItemsNested<A> setNewItemLike(int index,Fluentd item);
    public FluentdListFluent.ItemsNested<A> editItem(int index);
    public FluentdListFluent.ItemsNested<A> editFirstItem();
    public FluentdListFluent.ItemsNested<A> editLastItem();
    public FluentdListFluent.ItemsNested<A> editMatchingItem(Predicate<FluentdBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,FluentdFluent<FluentdListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
