package me.snowdrop.istio.mixer.adapter.denier;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface DenierListFluent<A extends DenierListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Denier item);
    public A setToItems(int index,Denier item);
    public A addToItems(Denier... items);
    public A addAllToItems(Collection<Denier> items);
    public A removeFromItems(Denier... items);
    public A removeAllFromItems(Collection<Denier> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Denier> getItems();
    public List<Denier> buildItems();
    public Denier buildItem(int index);
    public Denier buildFirstItem();
    public Denier buildLastItem();
    public Denier buildMatchingItem(Predicate<DenierBuilder> predicate);
    public A withItems(List<Denier> items);
    public A withItems(Denier... items);
    public Boolean hasItems();
    public DenierListFluent.ItemsNested<A> addNewItem();
    public DenierListFluent.ItemsNested<A> addNewItemLike(Denier item);
    public DenierListFluent.ItemsNested<A> setNewItemLike(int index,Denier item);
    public DenierListFluent.ItemsNested<A> editItem(int index);
    public DenierListFluent.ItemsNested<A> editFirstItem();
    public DenierListFluent.ItemsNested<A> editLastItem();
    public DenierListFluent.ItemsNested<A> editMatchingItem(Predicate<DenierBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,DenierFluent<DenierListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
