package me.snowdrop.istio.mixer.adapter.circonus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CirconusSpecFluentImpl<A extends CirconusSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CirconusSpecFluent<A>{

    private List<MetricInfoBuilder> metrics;
    private Long submissionInterval;
    private String submissionUrl;

    public CirconusSpecFluentImpl(){
    }
    public CirconusSpecFluentImpl(CirconusSpec instance){
            this.withMetrics(instance.getMetrics()); 
            this.withSubmissionInterval(instance.getSubmissionInterval()); 
            this.withSubmissionUrl(instance.getSubmissionUrl()); 
    }

    public A addToMetrics(int index,MetricInfo item){
            if (this.metrics == null) {this.metrics = new ArrayList<MetricInfoBuilder>();}
            MetricInfoBuilder builder = new MetricInfoBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.metrics.add(index >= 0 ? index : metrics.size(), builder); return (A)this;
    }

    public A setToMetrics(int index,MetricInfo item){
            if (this.metrics == null) {this.metrics = new ArrayList<MetricInfoBuilder>();}
            MetricInfoBuilder builder = new MetricInfoBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= metrics.size()) { metrics.add(builder); } else { metrics.set(index, builder);}
             return (A)this;
    }

    public A addToMetrics(MetricInfo... items){
            if (this.metrics == null) {this.metrics = new ArrayList<MetricInfoBuilder>();}
            for (MetricInfo item : items) {MetricInfoBuilder builder = new MetricInfoBuilder(item);_visitables.add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A addAllToMetrics(Collection<MetricInfo> items){
            if (this.metrics == null) {this.metrics = new ArrayList<MetricInfoBuilder>();}
            for (MetricInfo item : items) {MetricInfoBuilder builder = new MetricInfoBuilder(item);_visitables.add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A removeFromMetrics(MetricInfo... items){
            for (MetricInfo item : items) {MetricInfoBuilder builder = new MetricInfoBuilder(item);_visitables.remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    public A removeAllFromMetrics(Collection<MetricInfo> items){
            for (MetricInfo item : items) {MetricInfoBuilder builder = new MetricInfoBuilder(item);_visitables.remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<MetricInfo> getMetrics(){
            return build(metrics);
    }

    public List<MetricInfo> buildMetrics(){
            return build(metrics);
    }

    public MetricInfo buildMetric(int index){
            return this.metrics.get(index).build();
    }

    public MetricInfo buildFirstMetric(){
            return this.metrics.get(0).build();
    }

    public MetricInfo buildLastMetric(){
            return this.metrics.get(metrics.size() - 1).build();
    }

    public MetricInfo buildMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricInfoBuilder> predicate){
            for (MetricInfoBuilder item: metrics) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withMetrics(List<MetricInfo> metrics){
            if (this.metrics != null) { _visitables.removeAll(this.metrics);}
            if (metrics != null) {this.metrics = new ArrayList<MetricInfoBuilder>(); for (MetricInfo item : metrics){this.addToMetrics(item);}} else { this.metrics = null;} return (A) this;
    }

    public A withMetrics(MetricInfo... metrics){
            if (this.metrics != null) {this.metrics.clear();}
            if (metrics != null) {for (MetricInfo item :metrics){ this.addToMetrics(item);}} return (A) this;
    }

    public Boolean hasMetrics(){
            return metrics != null && !metrics.isEmpty();
    }

    public CirconusSpecFluent.MetricsNested<A> addNewMetric(){
            return new MetricsNestedImpl();
    }

    public CirconusSpecFluent.MetricsNested<A> addNewMetricLike(MetricInfo item){
            return new MetricsNestedImpl(-1, item);
    }

    public CirconusSpecFluent.MetricsNested<A> setNewMetricLike(int index,MetricInfo item){
            return new MetricsNestedImpl(index, item);
    }

    public CirconusSpecFluent.MetricsNested<A> editMetric(int index){
            if (metrics.size() <= index) throw new RuntimeException("Can't edit metrics. Index exceeds size.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public CirconusSpecFluent.MetricsNested<A> editFirstMetric(){
            if (metrics.size() == 0) throw new RuntimeException("Can't edit first metrics. The list is empty.");
            return setNewMetricLike(0, buildMetric(0));
    }

    public CirconusSpecFluent.MetricsNested<A> editLastMetric(){
            int index = metrics.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last metrics. The list is empty.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public CirconusSpecFluent.MetricsNested<A> editMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricInfoBuilder> predicate){
            int index = -1;
            for (int i=0;i<metrics.size();i++) { 
            if (predicate.apply(metrics.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching metrics. No match found.");
            return setNewMetricLike(index, buildMetric(index));
    }

    public Long getSubmissionInterval(){
            return this.submissionInterval;
    }

    public A withSubmissionInterval(Long submissionInterval){
            this.submissionInterval=submissionInterval; return (A) this;
    }

    public Boolean hasSubmissionInterval(){
            return this.submissionInterval != null;
    }

    public A withNewSubmissionInterval(String arg1){
            return (A)withSubmissionInterval(new Long(arg1));
    }

    public A withNewSubmissionInterval(long arg1){
            return (A)withSubmissionInterval(new Long(arg1));
    }

    public String getSubmissionUrl(){
            return this.submissionUrl;
    }

    public A withSubmissionUrl(String submissionUrl){
            this.submissionUrl=submissionUrl; return (A) this;
    }

    public Boolean hasSubmissionUrl(){
            return this.submissionUrl != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CirconusSpecFluentImpl that = (CirconusSpecFluentImpl) o;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (submissionInterval != null ? !submissionInterval.equals(that.submissionInterval) :that.submissionInterval != null) return false;
            if (submissionUrl != null ? !submissionUrl.equals(that.submissionUrl) :that.submissionUrl != null) return false;
            return true;
    }


    public class MetricsNestedImpl<N> extends MetricInfoFluentImpl<CirconusSpecFluent.MetricsNested<N>> implements CirconusSpecFluent.MetricsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final MetricInfoBuilder builder;
        private final int index;
    
            MetricsNestedImpl(int index,MetricInfo item){
                    this.index = index;
                    this.builder = new MetricInfoBuilder(this, item);
            }
            MetricsNestedImpl(){
                    this.index = -1;
                    this.builder = new MetricInfoBuilder(this);
            }
    
    public N and(){
            return (N) CirconusSpecFluentImpl.this.setToMetrics(index, builder.build());
    }
    public N endMetric(){
            return and();
    }

}


}
