package me.snowdrop.istio.mixer.adapter.circonus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class CirconusBuilder extends CirconusFluentImpl<CirconusBuilder> implements VisitableBuilder<Circonus,CirconusBuilder>{

    CirconusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CirconusBuilder(){
            this(true);
    }
    public CirconusBuilder(Boolean validationEnabled){
            this(new Circonus(), validationEnabled);
    }
    public CirconusBuilder(CirconusFluent<?> fluent){
            this(fluent, true);
    }
    public CirconusBuilder(CirconusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Circonus(), validationEnabled);
    }
    public CirconusBuilder(CirconusFluent<?> fluent,Circonus instance){
            this(fluent, instance, true);
    }
    public CirconusBuilder(CirconusFluent<?> fluent,Circonus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public CirconusBuilder(Circonus instance){
            this(instance,true);
    }
    public CirconusBuilder(Circonus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public CirconusBuilder(Validator validator){
            this(new Circonus(), true);
    }
    public CirconusBuilder(CirconusFluent<?> fluent,Circonus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public CirconusBuilder(Circonus instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Circonus build(){
            Circonus buildable = new Circonus(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CirconusBuilder that = (CirconusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
