package me.snowdrop.istio.mixer.adapter.bypass;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class BypassSpecBuilder extends BypassSpecFluentImpl<BypassSpecBuilder> implements VisitableBuilder<BypassSpec,BypassSpecBuilder>{

    BypassSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BypassSpecBuilder(){
            this(true);
    }
    public BypassSpecBuilder(Boolean validationEnabled){
            this(new BypassSpec(), validationEnabled);
    }
    public BypassSpecBuilder(BypassSpecFluent<?> fluent){
            this(fluent, true);
    }
    public BypassSpecBuilder(BypassSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BypassSpec(), validationEnabled);
    }
    public BypassSpecBuilder(BypassSpecFluent<?> fluent,BypassSpec instance){
            this(fluent, instance, true);
    }
    public BypassSpecBuilder(BypassSpecFluent<?> fluent,BypassSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBackendAddress(instance.getBackendAddress()); 
            fluent.withParams(instance.getParams()); 
            fluent.withSessionBased(instance.getSessionBased()); 
            this.validationEnabled = validationEnabled; 
    }
    public BypassSpecBuilder(BypassSpec instance){
            this(instance,true);
    }
    public BypassSpecBuilder(BypassSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBackendAddress(instance.getBackendAddress()); 
            this.withParams(instance.getParams()); 
            this.withSessionBased(instance.getSessionBased()); 
            this.validationEnabled = validationEnabled; 
    }
    public BypassSpecBuilder(Validator validator){
            this(new BypassSpec(), true);
    }
    public BypassSpecBuilder(BypassSpecFluent<?> fluent,BypassSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withBackendAddress(instance.getBackendAddress()); 
            fluent.withParams(instance.getParams()); 
            fluent.withSessionBased(instance.getSessionBased()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public BypassSpecBuilder(BypassSpec instance,Validator validator){
            this.fluent = this; 
            this.withBackendAddress(instance.getBackendAddress()); 
            this.withParams(instance.getParams()); 
            this.withSessionBased(instance.getSessionBased()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public BypassSpec build(){
            BypassSpec buildable = new BypassSpec(fluent.getBackendAddress(),fluent.getParams(),fluent.isSessionBased());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BypassSpecBuilder that = (BypassSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
