package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TargetFluentImpl<A extends TargetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TargetFluent<A>{

    private List<String> namespaces;
    private List<String> services;

    public TargetFluentImpl(){
    }
    public TargetFluentImpl(Target instance){
            this.withNamespaces(instance.getNamespaces()); 
            this.withServices(instance.getServices()); 
    }

    public A addToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.add(index, item);
            return (A)this;
    }

    public A setToNamespaces(int index,String item){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            this.namespaces.set(index, item); return (A)this;
    }

    public A addToNamespaces(String... items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A addAllToNamespaces(Collection<String> items){
            if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
            for (String item : items) {this.namespaces.add(item);} return (A)this;
    }

    public A removeFromNamespaces(String... items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromNamespaces(Collection<String> items){
            for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
    }

    public List<String> getNamespaces(){
            return this.namespaces;
    }

    public String getNamespace(int index){
            return this.namespaces.get(index);
    }

    public String getFirstNamespace(){
            return this.namespaces.get(0);
    }

    public String getLastNamespace(){
            return this.namespaces.get(namespaces.size() - 1);
    }

    public String getMatchingNamespace(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: namespaces) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withNamespaces(List<String> namespaces){
            if (this.namespaces != null) { _visitables.removeAll(this.namespaces);}
            if (namespaces != null) {this.namespaces = new ArrayList<String>(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
    }

    public A withNamespaces(String... namespaces){
            if (this.namespaces != null) {this.namespaces.clear();}
            if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
    }

    public Boolean hasNamespaces(){
            return namespaces != null && !namespaces.isEmpty();
    }

    public A addToServices(int index,String item){
            if (this.services == null) {this.services = new ArrayList<String>();}
            this.services.add(index, item);
            return (A)this;
    }

    public A setToServices(int index,String item){
            if (this.services == null) {this.services = new ArrayList<String>();}
            this.services.set(index, item); return (A)this;
    }

    public A addToServices(String... items){
            if (this.services == null) {this.services = new ArrayList<String>();}
            for (String item : items) {this.services.add(item);} return (A)this;
    }

    public A addAllToServices(Collection<String> items){
            if (this.services == null) {this.services = new ArrayList<String>();}
            for (String item : items) {this.services.add(item);} return (A)this;
    }

    public A removeFromServices(String... items){
            for (String item : items) {if (this.services!= null){ this.services.remove(item);}} return (A)this;
    }

    public A removeAllFromServices(Collection<String> items){
            for (String item : items) {if (this.services!= null){ this.services.remove(item);}} return (A)this;
    }

    public List<String> getServices(){
            return this.services;
    }

    public String getService(int index){
            return this.services.get(index);
    }

    public String getFirstService(){
            return this.services.get(0);
    }

    public String getLastService(){
            return this.services.get(services.size() - 1);
    }

    public String getMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: services) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withServices(List<String> services){
            if (this.services != null) { _visitables.removeAll(this.services);}
            if (services != null) {this.services = new ArrayList<String>(); for (String item : services){this.addToServices(item);}} else { this.services = null;} return (A) this;
    }

    public A withServices(String... services){
            if (this.services != null) {this.services.clear();}
            if (services != null) {for (String item :services){ this.addToServices(item);}} return (A) this;
    }

    public Boolean hasServices(){
            return services != null && !services.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TargetFluentImpl that = (TargetFluentImpl) o;
            if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
            if (services != null ? !services.equals(that.services) :that.services != null) return false;
            return true;
    }




}
