package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ServiceRoleSpecFluentImpl<A extends ServiceRoleSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceRoleSpecFluent<A>{

    private List<AccessRuleBuilder> rules;

    public ServiceRoleSpecFluentImpl(){
    }
    public ServiceRoleSpecFluentImpl(ServiceRoleSpec instance){
            this.withRules(instance.getRules()); 
    }

    public A addToRules(int index,AccessRule item){
            if (this.rules == null) {this.rules = new ArrayList<AccessRuleBuilder>();}
            AccessRuleBuilder builder = new AccessRuleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,AccessRule item){
            if (this.rules == null) {this.rules = new ArrayList<AccessRuleBuilder>();}
            AccessRuleBuilder builder = new AccessRuleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
             return (A)this;
    }

    public A addToRules(AccessRule... items){
            if (this.rules == null) {this.rules = new ArrayList<AccessRuleBuilder>();}
            for (AccessRule item : items) {AccessRuleBuilder builder = new AccessRuleBuilder(item);_visitables.add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<AccessRule> items){
            if (this.rules == null) {this.rules = new ArrayList<AccessRuleBuilder>();}
            for (AccessRule item : items) {AccessRuleBuilder builder = new AccessRuleBuilder(item);_visitables.add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(AccessRule... items){
            for (AccessRule item : items) {AccessRuleBuilder builder = new AccessRuleBuilder(item);_visitables.remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<AccessRule> items){
            for (AccessRule item : items) {AccessRuleBuilder builder = new AccessRuleBuilder(item);_visitables.remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<AccessRule> getRules(){
            return build(rules);
    }

    public List<AccessRule> buildRules(){
            return build(rules);
    }

    public AccessRule buildRule(int index){
            return this.rules.get(index).build();
    }

    public AccessRule buildFirstRule(){
            return this.rules.get(0).build();
    }

    public AccessRule buildLastRule(){
            return this.rules.get(rules.size() - 1).build();
    }

    public AccessRule buildMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<AccessRuleBuilder> predicate){
            for (AccessRuleBuilder item: rules) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withRules(List<AccessRule> rules){
            if (this.rules != null) { _visitables.removeAll(this.rules);}
            if (rules != null) {this.rules = new ArrayList<AccessRuleBuilder>(); for (AccessRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(AccessRule... rules){
            if (this.rules != null) {this.rules.clear();}
            if (rules != null) {for (AccessRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules(){
            return rules != null && !rules.isEmpty();
    }

    public ServiceRoleSpecFluent.RulesNested<A> addNewRule(){
            return new RulesNestedImpl();
    }

    public ServiceRoleSpecFluent.RulesNested<A> addNewRuleLike(AccessRule item){
            return new RulesNestedImpl(-1, item);
    }

    public ServiceRoleSpecFluent.RulesNested<A> setNewRuleLike(int index,AccessRule item){
            return new RulesNestedImpl(index, item);
    }

    public ServiceRoleSpecFluent.RulesNested<A> editRule(int index){
            if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
            return setNewRuleLike(index, buildRule(index));
    }

    public ServiceRoleSpecFluent.RulesNested<A> editFirstRule(){
            if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
            return setNewRuleLike(0, buildRule(0));
    }

    public ServiceRoleSpecFluent.RulesNested<A> editLastRule(){
            int index = rules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
            return setNewRuleLike(index, buildRule(index));
    }

    public ServiceRoleSpecFluent.RulesNested<A> editMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<AccessRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<rules.size();i++) { 
            if (predicate.apply(rules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
            return setNewRuleLike(index, buildRule(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceRoleSpecFluentImpl that = (ServiceRoleSpecFluentImpl) o;
            if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
            return true;
    }


    public class RulesNestedImpl<N> extends AccessRuleFluentImpl<ServiceRoleSpecFluent.RulesNested<N>> implements ServiceRoleSpecFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AccessRuleBuilder builder;
        private final int index;
    
            RulesNestedImpl(int index,AccessRule item){
                    this.index = index;
                    this.builder = new AccessRuleBuilder(this, item);
            }
            RulesNestedImpl(){
                    this.index = -1;
                    this.builder = new AccessRuleBuilder(this);
            }
    
    public N and(){
            return (N) ServiceRoleSpecFluentImpl.this.setToRules(index, builder.build());
    }
    public N endRule(){
            return and();
    }

}


}
