
package me.snowdrop.istio.api.rbac.v1alpha1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "mode",
    "roleRef",
    "subjects"
})
@IstioKind(name = "ServiceRoleBinding", plural = "servicerolebindings")
@IstioApiVersion("rbac.istio.io/v1alpha1")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class ServiceRoleBindingSpec implements Serializable, IstioSpec
{

    @JsonProperty("mode")
    private EnforcementMode mode;
    /**
     * 
     * 
     */
    @JsonProperty("roleRef")
    @JsonPropertyDescription("")
    @Valid
    private RoleRef roleRef;
    /**
     * 
     * 
     */
    @JsonProperty("subjects")
    @JsonPropertyDescription("")
    @Valid
    private List<Subject> subjects = new ArrayList<Subject>();
    private final static long serialVersionUID = -13959925338546622L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceRoleBindingSpec() {
    }

    /**
     * 
     * @param mode
     * @param subjects
     * @param roleRef
     */
    public ServiceRoleBindingSpec(EnforcementMode mode, RoleRef roleRef, List<Subject> subjects) {
        super();
        this.mode = mode;
        this.roleRef = roleRef;
        this.subjects = subjects;
    }

    @JsonProperty("mode")
    public EnforcementMode getMode() {
        return mode;
    }

    @JsonProperty("mode")
    public void setMode(EnforcementMode mode) {
        this.mode = mode;
    }

    /**
     * 
     * 
     */
    @JsonProperty("roleRef")
    public RoleRef getRoleRef() {
        return roleRef;
    }

    /**
     * 
     * 
     */
    @JsonProperty("roleRef")
    public void setRoleRef(RoleRef roleRef) {
        this.roleRef = roleRef;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subjects")
    public List<Subject> getSubjects() {
        return subjects;
    }

    /**
     * 
     * 
     */
    @JsonProperty("subjects")
    public void setSubjects(List<Subject> subjects) {
        this.subjects = subjects;
    }

}
