package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class AccessRuleBuilder extends AccessRuleFluentImpl<AccessRuleBuilder> implements VisitableBuilder<AccessRule,AccessRuleBuilder>{

    AccessRuleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AccessRuleBuilder(){
            this(true);
    }
    public AccessRuleBuilder(Boolean validationEnabled){
            this(new AccessRule(), validationEnabled);
    }
    public AccessRuleBuilder(AccessRuleFluent<?> fluent){
            this(fluent, true);
    }
    public AccessRuleBuilder(AccessRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AccessRule(), validationEnabled);
    }
    public AccessRuleBuilder(AccessRuleFluent<?> fluent,AccessRule instance){
            this(fluent, instance, true);
    }
    public AccessRuleBuilder(AccessRuleFluent<?> fluent,AccessRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConstraints(instance.getConstraints()); 
            fluent.withMethods(instance.getMethods()); 
            fluent.withPaths(instance.getPaths()); 
            fluent.withServices(instance.getServices()); 
            this.validationEnabled = validationEnabled; 
    }
    public AccessRuleBuilder(AccessRule instance){
            this(instance,true);
    }
    public AccessRuleBuilder(AccessRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConstraints(instance.getConstraints()); 
            this.withMethods(instance.getMethods()); 
            this.withPaths(instance.getPaths()); 
            this.withServices(instance.getServices()); 
            this.validationEnabled = validationEnabled; 
    }
    public AccessRuleBuilder(Validator validator){
            this(new AccessRule(), true);
    }
    public AccessRuleBuilder(AccessRuleFluent<?> fluent,AccessRule instance,Validator validator){
            this.fluent = fluent; 
            fluent.withConstraints(instance.getConstraints()); 
            fluent.withMethods(instance.getMethods()); 
            fluent.withPaths(instance.getPaths()); 
            fluent.withServices(instance.getServices()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public AccessRuleBuilder(AccessRule instance,Validator validator){
            this.fluent = this; 
            this.withConstraints(instance.getConstraints()); 
            this.withMethods(instance.getMethods()); 
            this.withPaths(instance.getPaths()); 
            this.withServices(instance.getServices()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public AccessRule build(){
            AccessRule buildable = new AccessRule(fluent.getConstraints(),fluent.getMethods(),fluent.getPaths(),fluent.getServices());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AccessRuleBuilder that = (AccessRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
