package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface RuleSpecFluent<A extends RuleSpecFluent<A>> extends Fluent<A>{


    public A addToActions(int index,Action item);
    public A setToActions(int index,Action item);
    public A addToActions(Action... items);
    public A addAllToActions(Collection<Action> items);
    public A removeFromActions(Action... items);
    public A removeAllFromActions(Collection<Action> items);
    
/**
 * This method has been deprecated, please use method buildActions instead.
 * @return The buildable object.
 */
@Deprecated public List<Action> getActions();
    public List<Action> buildActions();
    public Action buildAction(int index);
    public Action buildFirstAction();
    public Action buildLastAction();
    public Action buildMatchingAction(io.fabric8.kubernetes.api.builder.Predicate<ActionBuilder> predicate);
    public A withActions(List<Action> actions);
    public A withActions(Action... actions);
    public Boolean hasActions();
    public RuleSpecFluent.ActionsNested<A> addNewAction();
    public RuleSpecFluent.ActionsNested<A> addNewActionLike(Action item);
    public RuleSpecFluent.ActionsNested<A> setNewActionLike(int index,Action item);
    public RuleSpecFluent.ActionsNested<A> editAction(int index);
    public RuleSpecFluent.ActionsNested<A> editFirstAction();
    public RuleSpecFluent.ActionsNested<A> editLastAction();
    public RuleSpecFluent.ActionsNested<A> editMatchingAction(io.fabric8.kubernetes.api.builder.Predicate<ActionBuilder> predicate);
    public String getMatch();
    public A withMatch(String match);
    public Boolean hasMatch();

    public interface ActionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ActionFluent<RuleSpecFluent.ActionsNested<N>>{

        
    public N and();    public N endAction();
}


}
