package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Predicate;

public interface TLSSettingsFluent<A extends TLSSettingsFluent<A>> extends Fluent<A>{


    public String getCaCertificates();
    public A withCaCertificates(String caCertificates);
    public Boolean hasCaCertificates();
    public String getClientCertificate();
    public A withClientCertificate(String clientCertificate);
    public Boolean hasClientCertificate();
    public TLSSettingsMode getMode();
    public A withMode(TLSSettingsMode mode);
    public Boolean hasMode();
    public String getPrivateKey();
    public A withPrivateKey(String privateKey);
    public Boolean hasPrivateKey();
    public String getSni();
    public A withSni(String sni);
    public Boolean hasSni();
    public A addToSubjectAltNames(int index,String item);
    public A setToSubjectAltNames(int index,String item);
    public A addToSubjectAltNames(String... items);
    public A addAllToSubjectAltNames(Collection<String> items);
    public A removeFromSubjectAltNames(String... items);
    public A removeAllFromSubjectAltNames(Collection<String> items);
    public List<String> getSubjectAltNames();
    public String getSubjectAltName(int index);
    public String getFirstSubjectAltName();
    public String getLastSubjectAltName();
    public String getMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withSubjectAltNames(List<String> subjectAltNames);
    public A withSubjectAltNames(String... subjectAltNames);
    public Boolean hasSubjectAltNames();



}
