
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "match",
    "route"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TLSRoute implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("match")
    @JsonPropertyDescription("")
    @Valid
    private List<TLSMatchAttributes> match = new ArrayList<TLSMatchAttributes>();
    /**
     * 
     * 
     */
    @JsonProperty("route")
    @JsonPropertyDescription("")
    @Valid
    private List<DestinationWeight> route = new ArrayList<DestinationWeight>();
    private final static long serialVersionUID = -8697042952349412552L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TLSRoute() {
    }

    /**
     * 
     * @param route
     * @param match
     */
    public TLSRoute(List<TLSMatchAttributes> match, List<DestinationWeight> route) {
        super();
        this.match = match;
        this.route = route;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public List<TLSMatchAttributes> getMatch() {
        return match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("match")
    public void setMatch(List<TLSMatchAttributes> match) {
        this.match = match;
    }

    /**
     * 
     * 
     */
    @JsonProperty("route")
    public List<DestinationWeight> getRoute() {
        return route;
    }

    /**
     * 
     * 
     */
    @JsonProperty("route")
    public void setRoute(List<DestinationWeight> route) {
        this.route = route;
    }

}
