package me.snowdrop.istio.api.networking.v1alpha3;

import me.snowdrop.istio.api.DurationFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import java.lang.Override;
import com.fasterxml.jackson.core.JsonParser;
import me.snowdrop.istio.api.Duration;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import me.snowdrop.istio.api.DurationBuilder;

public class TCPSettingsFluentImpl<A extends TCPSettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TCPSettingsFluent<A>{

    private DurationBuilder connectTimeout;
    private Integer maxConnections;

    public TCPSettingsFluentImpl(){
    }
    public TCPSettingsFluentImpl(TCPSettings instance){
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withMaxConnections(instance.getMaxConnections()); 
    }

    
/**
 * This method has been deprecated, please use method buildConnectTimeout instead.
 * @return The buildable object.
 */
@Deprecated public Duration getConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public Duration buildConnectTimeout(){
            return this.connectTimeout!=null?this.connectTimeout.build():null;
    }

    public A withConnectTimeout(Duration connectTimeout){
            _visitables.remove(this.connectTimeout);
            if (connectTimeout!=null){ this.connectTimeout= new DurationBuilder(connectTimeout); _visitables.add(this.connectTimeout);} return (A) this;
    }

    public Boolean hasConnectTimeout(){
            return this.connectTimeout != null;
    }

    public A withNewConnectTimeout(Integer nanos,Long seconds){
            return (A)withConnectTimeout(new Duration(nanos, seconds));
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> withNewConnectTimeout(){
            return new ConnectTimeoutNestedImpl();
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> withNewConnectTimeoutLike(Duration item){
            return new ConnectTimeoutNestedImpl(item);
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> editConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout());
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> editOrNewConnectTimeout(){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): new DurationBuilder().build());
    }

    public TCPSettingsFluent.ConnectTimeoutNested<A> editOrNewConnectTimeoutLike(Duration item){
            return withNewConnectTimeoutLike(getConnectTimeout() != null ? getConnectTimeout(): item);
    }

    public Integer getMaxConnections(){
            return this.maxConnections;
    }

    public A withMaxConnections(Integer maxConnections){
            this.maxConnections=maxConnections; return (A) this;
    }

    public Boolean hasMaxConnections(){
            return this.maxConnections != null;
    }

    public A withNewMaxConnections(String arg1){
            return (A)withMaxConnections(new Integer(arg1));
    }

    public A withNewMaxConnections(int arg1){
            return (A)withMaxConnections(new Integer(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TCPSettingsFluentImpl that = (TCPSettingsFluentImpl) o;
            if (connectTimeout != null ? !connectTimeout.equals(that.connectTimeout) :that.connectTimeout != null) return false;
            if (maxConnections != null ? !maxConnections.equals(that.maxConnections) :that.maxConnections != null) return false;
            return true;
    }


    public class ConnectTimeoutNestedImpl<N> extends DurationFluentImpl<TCPSettingsFluent.ConnectTimeoutNested<N>> implements TCPSettingsFluent.ConnectTimeoutNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DurationBuilder builder;
    
            ConnectTimeoutNestedImpl(Duration item){
                    this.builder = new DurationBuilder(this, item);
            }
            ConnectTimeoutNestedImpl(){
                    this.builder = new DurationBuilder(this);
            }
    
    public N and(){
            return (N) TCPSettingsFluentImpl.this.withConnectTimeout(builder.build());
    }
    public N endConnectTimeout(){
            return and();
    }

}


}
