package me.snowdrop.istio.api.networking.v1alpha3;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class PortFluentImpl<A extends PortFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PortFluent<A>{

    private String name;
    private Integer number;
    private String protocol;

    public PortFluentImpl(){
    }
    public PortFluentImpl(me.snowdrop.istio.api.networking.v1alpha3.Port instance){
            this.withName(instance.getName()); 
            this.withNumber(instance.getNumber()); 
            this.withProtocol(instance.getProtocol()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public Integer getNumber(){
            return this.number;
    }

    public A withNumber(Integer number){
            this.number=number; return (A) this;
    }

    public Boolean hasNumber(){
            return this.number != null;
    }

    public A withNewNumber(String arg1){
            return (A)withNumber(new Integer(arg1));
    }

    public A withNewNumber(int arg1){
            return (A)withNumber(new Integer(arg1));
    }

    public String getProtocol(){
            return this.protocol;
    }

    public A withProtocol(String protocol){
            this.protocol=protocol; return (A) this;
    }

    public Boolean hasProtocol(){
            return this.protocol != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PortFluentImpl that = (PortFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (number != null ? !number.equals(that.number) :that.number != null) return false;
            if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
            return true;
    }




}
