
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "destinationSubnets",
    "gateways",
    "port",
    "sourceLabels",
    "sourceSubnet"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class L4MatchAttributes implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("destinationSubnets")
    @JsonPropertyDescription("")
    @Valid
    private List<java.lang.String> destinationSubnets = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    @JsonPropertyDescription("")
    @Valid
    private List<java.lang.String> gateways = new ArrayList<java.lang.String>();
    /**
     * 
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Integer port;
    /**
     * 
     * 
     */
    @JsonProperty("sourceLabels")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, String> sourceLabels;
    /**
     * 
     * 
     */
    @JsonProperty("sourceSubnet")
    @JsonPropertyDescription("")
    private java.lang.String sourceSubnet;
    private final static long serialVersionUID = 3998096620398162656L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public L4MatchAttributes() {
    }

    /**
     * 
     * @param gateways
     * @param destinationSubnets
     * @param sourceSubnet
     * @param port
     * @param sourceLabels
     */
    public L4MatchAttributes(List<java.lang.String> destinationSubnets, List<java.lang.String> gateways, Integer port, Map<String, String> sourceLabels, java.lang.String sourceSubnet) {
        super();
        this.destinationSubnets = destinationSubnets;
        this.gateways = gateways;
        this.port = port;
        this.sourceLabels = sourceLabels;
        this.sourceSubnet = sourceSubnet;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationSubnets")
    public List<java.lang.String> getDestinationSubnets() {
        return destinationSubnets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("destinationSubnets")
    public void setDestinationSubnets(List<java.lang.String> destinationSubnets) {
        this.destinationSubnets = destinationSubnets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    public List<java.lang.String> getGateways() {
        return gateways;
    }

    /**
     * 
     * 
     */
    @JsonProperty("gateways")
    public void setGateways(List<java.lang.String> gateways) {
        this.gateways = gateways;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public Integer getPort() {
        return port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("port")
    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceLabels")
    public Map<String, String> getSourceLabels() {
        return sourceLabels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceLabels")
    public void setSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceSubnet")
    public java.lang.String getSourceSubnet() {
        return sourceSubnet;
    }

    /**
     * 
     * 
     */
    @JsonProperty("sourceSubnet")
    public void setSourceSubnet(java.lang.String sourceSubnet) {
        this.sourceSubnet = sourceSubnet;
    }

}
