package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class HTTPSettingsBuilder extends HTTPSettingsFluentImpl<HTTPSettingsBuilder> implements VisitableBuilder<HTTPSettings,HTTPSettingsBuilder>{

    HTTPSettingsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPSettingsBuilder(){
            this(true);
    }
    public HTTPSettingsBuilder(Boolean validationEnabled){
            this(new HTTPSettings(), validationEnabled);
    }
    public HTTPSettingsBuilder(HTTPSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPSettingsBuilder(HTTPSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPSettings(), validationEnabled);
    }
    public HTTPSettingsBuilder(HTTPSettingsFluent<?> fluent,HTTPSettings instance){
            this(fluent, instance, true);
    }
    public HTTPSettingsBuilder(HTTPSettingsFluent<?> fluent,HTTPSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
            fluent.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
            fluent.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
            fluent.withMaxRetries(instance.getMaxRetries()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPSettingsBuilder(HTTPSettings instance){
            this(instance,true);
    }
    public HTTPSettingsBuilder(HTTPSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
            this.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
            this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
            this.withMaxRetries(instance.getMaxRetries()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPSettingsBuilder(Validator validator){
            this(new HTTPSettings(), true);
    }
    public HTTPSettingsBuilder(HTTPSettingsFluent<?> fluent,HTTPSettings instance,Validator validator){
            this.fluent = fluent; 
            fluent.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
            fluent.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
            fluent.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
            fluent.withMaxRetries(instance.getMaxRetries()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public HTTPSettingsBuilder(HTTPSettings instance,Validator validator){
            this.fluent = this; 
            this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
            this.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
            this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
            this.withMaxRetries(instance.getMaxRetries()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public HTTPSettings build(){
            HTTPSettings buildable = new HTTPSettings(fluent.getHttp1MaxPendingRequests(),fluent.getHttp2MaxRequests(),fluent.getMaxRequestsPerConnection(),fluent.getMaxRetries());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPSettingsBuilder that = (HTTPSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
