package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class HTTPRouteBuilder extends HTTPRouteFluentImpl<HTTPRouteBuilder> implements VisitableBuilder<HTTPRoute,HTTPRouteBuilder>{

    HTTPRouteFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPRouteBuilder(){
            this(true);
    }
    public HTTPRouteBuilder(Boolean validationEnabled){
            this(new HTTPRoute(), validationEnabled);
    }
    public HTTPRouteBuilder(HTTPRouteFluent<?> fluent){
            this(fluent, true);
    }
    public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HTTPRoute(), validationEnabled);
    }
    public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,HTTPRoute instance){
            this(fluent, instance, true);
    }
    public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,HTTPRoute instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAppendHeaders(instance.getAppendHeaders()); 
            fluent.withCorsPolicy(instance.getCorsPolicy()); 
            fluent.withFault(instance.getFault()); 
            fluent.withMatch(instance.getMatch()); 
            fluent.withMirror(instance.getMirror()); 
            fluent.withRedirect(instance.getRedirect()); 
            fluent.withRemoveResponseHeaders(instance.getRemoveResponseHeaders()); 
            fluent.withRetries(instance.getRetries()); 
            fluent.withRewrite(instance.getRewrite()); 
            fluent.withRoute(instance.getRoute()); 
            fluent.withTimeout(instance.getTimeout()); 
            fluent.withWebsocketUpgrade(instance.getWebsocketUpgrade()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPRouteBuilder(HTTPRoute instance){
            this(instance,true);
    }
    public HTTPRouteBuilder(HTTPRoute instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAppendHeaders(instance.getAppendHeaders()); 
            this.withCorsPolicy(instance.getCorsPolicy()); 
            this.withFault(instance.getFault()); 
            this.withMatch(instance.getMatch()); 
            this.withMirror(instance.getMirror()); 
            this.withRedirect(instance.getRedirect()); 
            this.withRemoveResponseHeaders(instance.getRemoveResponseHeaders()); 
            this.withRetries(instance.getRetries()); 
            this.withRewrite(instance.getRewrite()); 
            this.withRoute(instance.getRoute()); 
            this.withTimeout(instance.getTimeout()); 
            this.withWebsocketUpgrade(instance.getWebsocketUpgrade()); 
            this.validationEnabled = validationEnabled; 
    }
    public HTTPRouteBuilder(Validator validator){
            this(new HTTPRoute(), true);
    }
    public HTTPRouteBuilder(HTTPRouteFluent<?> fluent,HTTPRoute instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAppendHeaders(instance.getAppendHeaders()); 
            fluent.withCorsPolicy(instance.getCorsPolicy()); 
            fluent.withFault(instance.getFault()); 
            fluent.withMatch(instance.getMatch()); 
            fluent.withMirror(instance.getMirror()); 
            fluent.withRedirect(instance.getRedirect()); 
            fluent.withRemoveResponseHeaders(instance.getRemoveResponseHeaders()); 
            fluent.withRetries(instance.getRetries()); 
            fluent.withRewrite(instance.getRewrite()); 
            fluent.withRoute(instance.getRoute()); 
            fluent.withTimeout(instance.getTimeout()); 
            fluent.withWebsocketUpgrade(instance.getWebsocketUpgrade()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public HTTPRouteBuilder(HTTPRoute instance,Validator validator){
            this.fluent = this; 
            this.withAppendHeaders(instance.getAppendHeaders()); 
            this.withCorsPolicy(instance.getCorsPolicy()); 
            this.withFault(instance.getFault()); 
            this.withMatch(instance.getMatch()); 
            this.withMirror(instance.getMirror()); 
            this.withRedirect(instance.getRedirect()); 
            this.withRemoveResponseHeaders(instance.getRemoveResponseHeaders()); 
            this.withRetries(instance.getRetries()); 
            this.withRewrite(instance.getRewrite()); 
            this.withRoute(instance.getRoute()); 
            this.withTimeout(instance.getTimeout()); 
            this.withWebsocketUpgrade(instance.getWebsocketUpgrade()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public HTTPRoute build(){
            HTTPRoute buildable = new HTTPRoute(fluent.getAppendHeaders(),fluent.getCorsPolicy(),fluent.getFault(),fluent.getMatch(),fluent.getMirror(),fluent.getRedirect(),fluent.getRemoveResponseHeaders(),fluent.getRetries(),fluent.getRewrite(),fluent.getRoute(),fluent.getTimeout(),fluent.isWebsocketUpgrade());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPRouteBuilder that = (HTTPRouteBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
