
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;
import me.snowdrop.istio.api.networking.v1alpha3.Delay.HttpDelayType;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "exponentialDelay"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class ExponentialDelayHttpDelayType implements Serializable, HttpDelayType
{

    /**
     * 
     * 
     */
    @JsonProperty("exponentialDelay")
    @JsonPropertyDescription("")
    @Valid
    private Duration exponentialDelay;
    private final static long serialVersionUID = -7052020232853239145L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ExponentialDelayHttpDelayType() {
    }

    /**
     * 
     * @param exponentialDelay
     */
    public ExponentialDelayHttpDelayType(Duration exponentialDelay) {
        super();
        this.exponentialDelay = exponentialDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exponentialDelay")
    public Duration getExponentialDelay() {
        return exponentialDelay;
    }

    /**
     * 
     * 
     */
    @JsonProperty("exponentialDelay")
    public void setExponentialDelay(Duration exponentialDelay) {
        this.exponentialDelay = exponentialDelay;
    }

}
