package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface EnvoyFilterSpecFluent<A extends EnvoyFilterSpecFluent<A>> extends Fluent<A>{


    public A addToFilters(int index,Filter item);
    public A setToFilters(int index,Filter item);
    public A addToFilters(Filter... items);
    public A addAllToFilters(Collection<Filter> items);
    public A removeFromFilters(Filter... items);
    public A removeAllFromFilters(Collection<Filter> items);
    
/**
 * This method has been deprecated, please use method buildFilters instead.
 * @return The buildable object.
 */
@Deprecated public List<Filter> getFilters();
    public List<Filter> buildFilters();
    public Filter buildFilter(int index);
    public Filter buildFirstFilter();
    public Filter buildLastFilter();
    public Filter buildMatchingFilter(io.fabric8.kubernetes.api.builder.Predicate<FilterBuilder> predicate);
    public A withFilters(List<Filter> filters);
    public A withFilters(Filter... filters);
    public Boolean hasFilters();
    public EnvoyFilterSpecFluent.FiltersNested<A> addNewFilter();
    public EnvoyFilterSpecFluent.FiltersNested<A> addNewFilterLike(Filter item);
    public EnvoyFilterSpecFluent.FiltersNested<A> setNewFilterLike(int index,Filter item);
    public EnvoyFilterSpecFluent.FiltersNested<A> editFilter(int index);
    public EnvoyFilterSpecFluent.FiltersNested<A> editFirstFilter();
    public EnvoyFilterSpecFluent.FiltersNested<A> editLastFilter();
    public EnvoyFilterSpecFluent.FiltersNested<A> editMatchingFilter(io.fabric8.kubernetes.api.builder.Predicate<FilterBuilder> predicate);
    public A addToWorkloadLabels(String key,String value);
    public A addToWorkloadLabels(Map<String,String> map);
    public A removeFromWorkloadLabels(String key);
    public A removeFromWorkloadLabels(Map<String,String> map);
    public Map<String,String> getWorkloadLabels();
    public A withWorkloadLabels(Map<String,String> workloadLabels);
    public Boolean hasWorkloadLabels();

    public interface FiltersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FilterFluent<EnvoyFilterSpecFluent.FiltersNested<N>>{

        
    public N and();    public N endFilter();
}


}
