package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface DestinationRuleSpecFluent<A extends DestinationRuleSpecFluent<A>> extends Fluent<A>{


    public String getHost();
    public A withHost(String host);
    public Boolean hasHost();
    public A addToSubsets(int index,Subset item);
    public A setToSubsets(int index,Subset item);
    public A addToSubsets(Subset... items);
    public A addAllToSubsets(Collection<Subset> items);
    public A removeFromSubsets(Subset... items);
    public A removeAllFromSubsets(Collection<Subset> items);
    
/**
 * This method has been deprecated, please use method buildSubsets instead.
 * @return The buildable object.
 */
@Deprecated public List<Subset> getSubsets();
    public List<Subset> buildSubsets();
    public Subset buildSubset(int index);
    public Subset buildFirstSubset();
    public Subset buildLastSubset();
    public Subset buildMatchingSubset(io.fabric8.kubernetes.api.builder.Predicate<SubsetBuilder> predicate);
    public A withSubsets(List<Subset> subsets);
    public A withSubsets(Subset... subsets);
    public Boolean hasSubsets();
    public DestinationRuleSpecFluent.SubsetsNested<A> addNewSubset();
    public DestinationRuleSpecFluent.SubsetsNested<A> addNewSubsetLike(Subset item);
    public DestinationRuleSpecFluent.SubsetsNested<A> setNewSubsetLike(int index,Subset item);
    public DestinationRuleSpecFluent.SubsetsNested<A> editSubset(int index);
    public DestinationRuleSpecFluent.SubsetsNested<A> editFirstSubset();
    public DestinationRuleSpecFluent.SubsetsNested<A> editLastSubset();
    public DestinationRuleSpecFluent.SubsetsNested<A> editMatchingSubset(io.fabric8.kubernetes.api.builder.Predicate<SubsetBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public TrafficPolicy getTrafficPolicy();
    public TrafficPolicy buildTrafficPolicy();
    public A withTrafficPolicy(TrafficPolicy trafficPolicy);
    public Boolean hasTrafficPolicy();
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> withNewTrafficPolicy();
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> withNewTrafficPolicyLike(TrafficPolicy item);
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> editTrafficPolicy();
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> editOrNewTrafficPolicy();
    public DestinationRuleSpecFluent.TrafficPolicyNested<A> editOrNewTrafficPolicyLike(TrafficPolicy item);

    public interface SubsetsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SubsetFluent<DestinationRuleSpecFluent.SubsetsNested<N>>{

        
    public N and();    public N endSubset();
}
    public interface TrafficPolicyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TrafficPolicyFluent<DestinationRuleSpecFluent.TrafficPolicyNested<N>>{

        
    public N and();    public N endTrafficPolicy();
}


}
