package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class DestinationRuleSpecBuilder extends DestinationRuleSpecFluentImpl<DestinationRuleSpecBuilder> implements VisitableBuilder<DestinationRuleSpec,DestinationRuleSpecBuilder>{

    DestinationRuleSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public DestinationRuleSpecBuilder(){
            this(true);
    }
    public DestinationRuleSpecBuilder(Boolean validationEnabled){
            this(new DestinationRuleSpec(), validationEnabled);
    }
    public DestinationRuleSpecBuilder(DestinationRuleSpecFluent<?> fluent){
            this(fluent, true);
    }
    public DestinationRuleSpecBuilder(DestinationRuleSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DestinationRuleSpec(), validationEnabled);
    }
    public DestinationRuleSpecBuilder(DestinationRuleSpecFluent<?> fluent,DestinationRuleSpec instance){
            this(fluent, instance, true);
    }
    public DestinationRuleSpecBuilder(DestinationRuleSpecFluent<?> fluent,DestinationRuleSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHost(instance.getHost()); 
            fluent.withSubsets(instance.getSubsets()); 
            fluent.withTrafficPolicy(instance.getTrafficPolicy()); 
            this.validationEnabled = validationEnabled; 
    }
    public DestinationRuleSpecBuilder(DestinationRuleSpec instance){
            this(instance,true);
    }
    public DestinationRuleSpecBuilder(DestinationRuleSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHost(instance.getHost()); 
            this.withSubsets(instance.getSubsets()); 
            this.withTrafficPolicy(instance.getTrafficPolicy()); 
            this.validationEnabled = validationEnabled; 
    }
    public DestinationRuleSpecBuilder(Validator validator){
            this(new DestinationRuleSpec(), true);
    }
    public DestinationRuleSpecBuilder(DestinationRuleSpecFluent<?> fluent,DestinationRuleSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withHost(instance.getHost()); 
            fluent.withSubsets(instance.getSubsets()); 
            fluent.withTrafficPolicy(instance.getTrafficPolicy()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public DestinationRuleSpecBuilder(DestinationRuleSpec instance,Validator validator){
            this.fluent = this; 
            this.withHost(instance.getHost()); 
            this.withSubsets(instance.getSubsets()); 
            this.withTrafficPolicy(instance.getTrafficPolicy()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public DestinationRuleSpec build(){
            DestinationRuleSpec buildable = new DestinationRuleSpec(fluent.getHost(),fluent.getSubsets(),fluent.getTrafficPolicy());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DestinationRuleSpecBuilder that = (DestinationRuleSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
